import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ChangeIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 20 20"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M18.0917 7.74166L14.7583 4.40833C14.6806 4.33063 14.5884 4.269 14.4869 4.22695C14.3854 4.1849 14.2765 4.16325 14.1667 4.16325C13.9447 4.16325 13.7319 4.25141 13.575 4.40833C13.4181 4.56525 13.3299 4.77808 13.3299 5C13.3299 5.22192 13.4181 5.43474 13.575 5.59166L15.4917 7.5H5.83333C5.61232 7.5 5.40036 7.58779 5.24408 7.74407C5.0878 7.90036 5 8.11232 5 8.33333C5 8.55434 5.0878 8.76631 5.24408 8.92259C5.40036 9.07887 5.61232 9.16666 5.83333 9.16666H17.5C17.6645 9.16584 17.8251 9.11634 17.9616 9.0244C18.098 8.93245 18.2041 8.80218 18.2667 8.65C18.3305 8.49824 18.3479 8.33098 18.3168 8.16932C18.2856 8.00766 18.2073 7.85885 18.0917 7.74166ZM14.1667 10.8333H2.5C2.33548 10.8342 2.17488 10.8837 2.03845 10.9756C1.90202 11.0675 1.79585 11.1978 1.73333 11.35C1.66952 11.5018 1.65208 11.669 1.68323 11.8307C1.71437 11.9923 1.7927 12.1411 1.90833 12.2583L5.24167 15.5917C5.31914 15.6698 5.4113 15.7318 5.51285 15.7741C5.6144 15.8164 5.72332 15.8382 5.83333 15.8382C5.94334 15.8382 6.05227 15.8164 6.15381 15.7741C6.25536 15.7318 6.34753 15.6698 6.425 15.5917C6.50311 15.5142 6.5651 15.422 6.60741 15.3205C6.64972 15.2189 6.6715 15.11 6.6715 15C6.6715 14.89 6.64972 14.7811 6.60741 14.6795C6.5651 14.578 6.50311 14.4858 6.425 14.4083L4.50833 12.5H14.1667C14.3877 12.5 14.5996 12.4122 14.7559 12.2559C14.9122 12.0996 15 11.8877 15 11.6667C15 11.4456 14.9122 11.2337 14.7559 11.0774C14.5996 10.9211 14.3877 10.8333 14.1667 10.8333Z"
            fill={props.fill}
        />
    </svg>
);

ChangeIcon.defaultProps = {
    width: 20,
    height: 20,
    fill: 'currentColor',
};

export default ChangeIcon;
