import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DownloadIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 20 20"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M15.833 16.666H4.16634C3.94533 16.666 3.73337 16.7538 3.57709 16.9101C3.42081 17.0664 3.33301 17.2783 3.33301 17.4993C3.33301 17.7204 3.42081 17.9323 3.57709 18.0886C3.73337 18.2449 3.94533 18.3327 4.16634 18.3327H15.833C16.054 18.3327 16.266 18.2449 16.4223 18.0886C16.5785 17.9323 16.6663 17.7204 16.6663 17.4993C16.6663 17.2783 16.5785 17.0664 16.4223 16.9101C16.266 16.7538 16.054 16.666 15.833 16.666ZM9.40801 14.7577C9.48726 14.8335 9.58071 14.893 9.68301 14.9327C9.78276 14.9768 9.89062 14.9995 9.99967 14.9995C10.1087 14.9995 10.2166 14.9768 10.3163 14.9327C10.4186 14.893 10.5121 14.8335 10.5913 14.7577L13.9247 11.4243C14.0816 11.2674 14.1698 11.0546 14.1698 10.8327C14.1698 10.6108 14.0816 10.3979 13.9247 10.241C13.7678 10.0841 13.5549 9.99594 13.333 9.99594C13.1111 9.99594 12.8983 10.0841 12.7413 10.241L10.833 12.1577V2.49935C10.833 2.27834 10.7452 2.06637 10.5889 1.91009C10.4326 1.75381 10.2207 1.66602 9.99967 1.66602C9.77866 1.66602 9.5667 1.75381 9.41042 1.91009C9.25414 2.06637 9.16634 2.27834 9.16634 2.49935V12.1577L7.25801 10.241C7.18031 10.1633 7.08807 10.1017 6.98655 10.0596C6.88503 10.0176 6.77622 9.99594 6.66634 9.99594C6.55646 9.99594 6.44765 10.0176 6.34613 10.0596C6.24462 10.1017 6.15237 10.1633 6.07467 10.241C5.99698 10.3187 5.93534 10.411 5.89329 10.5125C5.85124 10.614 5.8296 10.7228 5.8296 10.8327C5.8296 10.9426 5.85124 11.0514 5.89329 11.1529C5.93534 11.2544 5.99698 11.3467 6.07467 11.4243L9.40801 14.7577Z"
            fill={props.fill}
        />
    </svg>
);

DownloadIcon.defaultProps = {
    width: 20,
    height: 20,
    fill: 'currentColor',
};

export default DownloadIcon;
