import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const KnowledgeBaseIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 20 20"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M11.1822 0.150909C10.6044 0.00909091 10.0044 0 9.12267 0H7.12C6.40444 0 5.81333 2.7093e-08 5.33333 0.04C4.83289 0.0818182 4.37333 0.171818 3.94222 0.396364C3.27323 0.744989 2.72932 1.30126 2.38844 1.98545C2.16889 2.42636 2.08089 2.89636 2.04 3.40727C2 3.9 2 4.50364 2 5.23455V14.7645C2 15.4964 2 16.1009 2.03911 16.5918C2.08 17.1036 2.168 17.5736 2.38756 18.0145C2.72843 18.6987 3.27234 19.255 3.94133 19.6036C4.37244 19.8282 4.832 19.9182 5.33156 19.96C5.81333 20 6.40356 20 7.11822 20H12.8809C13.5964 20 14.1876 20 14.6676 19.96C15.168 19.9182 15.6276 19.8282 16.0587 19.6036C16.7277 19.255 17.2716 18.6987 17.6124 18.0145C17.832 17.5736 17.92 17.1036 17.9609 16.5927C18 16.1009 18 15.4964 18 14.7655V9.26364C18 8.25909 18 7.60091 17.8524 6.97273C17.722 6.41597 17.5066 5.8837 17.2142 5.39545C16.8836 4.84364 16.4293 4.37909 15.7342 3.66818L15.6569 3.59L14.4889 2.39545L14.4124 2.31636C13.7173 1.60636 13.2631 1.14091 12.7236 0.802727C12.2464 0.50381 11.7263 0.28354 11.1822 0.15V0.150909ZM8.832 1.81818H9.152C10.6809 1.84 10.7111 3.09 10.7413 4.39364C10.7627 5.31182 10.7858 6.25727 11.3333 6.81818C11.8818 7.37909 12.8062 7.40182 13.704 7.42364C14.9796 7.45455 16.2018 7.48455 16.2222 9.05091V14.7273C16.2222 15.5064 16.2222 16.0355 16.1884 16.4445C16.1573 16.8427 16.0996 17.0473 16.0284 17.1891C15.858 17.5312 15.5861 17.8093 15.2516 17.9836C15.1129 18.0564 14.9138 18.1155 14.5236 18.1473C14.1236 18.1809 13.6062 18.1818 12.8444 18.1818H7.15556C6.39378 18.1818 5.87644 18.1818 5.47644 18.1473C5.08711 18.1155 4.88711 18.0564 4.74844 17.9836C4.41395 17.8093 4.14199 17.5312 3.97156 17.1891C3.90044 17.0473 3.84267 16.8436 3.81156 16.4445C3.77778 16.0355 3.77778 15.5064 3.77778 14.7273V5.27273C3.77778 4.49364 3.77778 3.96455 3.81156 3.55545C3.84267 3.15727 3.90044 2.95273 3.97156 2.81091C4.14199 2.46881 4.41395 2.19068 4.74844 2.01636C4.88711 1.94364 5.08622 1.88455 5.47644 1.85273C5.87644 1.81818 6.39378 1.81818 7.15556 1.81818H8.832ZM6.44444 11.8182C6.2087 11.8182 5.9826 11.914 5.81591 12.0844C5.64921 12.2549 5.55556 12.4862 5.55556 12.7273C5.55556 12.9684 5.64921 13.1996 5.81591 13.3701C5.9826 13.5406 6.2087 13.6364 6.44444 13.6364H7.33333C7.56908 13.6364 7.79517 13.5406 7.96187 13.3701C8.12857 13.1996 8.22222 12.9684 8.22222 12.7273C8.22222 12.4862 8.12857 12.2549 7.96187 12.0844C7.79517 11.914 7.56908 11.8182 7.33333 11.8182H6.44444ZM5.55556 15.4545C5.55556 15.2134 5.64921 14.9822 5.81591 14.8117C5.9826 14.6412 6.2087 14.5455 6.44444 14.5455H9.11111C9.34686 14.5455 9.57295 14.6412 9.73965 14.8117C9.90635 14.9822 10 15.2134 10 15.4545C10 15.6957 9.90635 15.9269 9.73965 16.0974C9.57295 16.2679 9.34686 16.3636 9.11111 16.3636H6.44444C6.2087 16.3636 5.9826 16.2679 5.81591 16.0974C5.64921 15.9269 5.55556 15.6957 5.55556 15.4545ZM11.7778 14.5455C11.542 14.5455 11.3159 14.6412 11.1492 14.8117C10.9825 14.9822 10.8889 15.2134 10.8889 15.4545C10.8889 15.6957 10.9825 15.9269 11.1492 16.0974C11.3159 16.2679 11.542 16.3636 11.7778 16.3636H13.5556C13.7913 16.3636 14.0174 16.2679 14.1841 16.0974C14.3508 15.9269 14.4444 15.6957 14.4444 15.4545C14.4444 15.2134 14.3508 14.9822 14.1841 14.8117C14.0174 14.6412 13.7913 14.5455 13.5556 14.5455H11.7778ZM10 11.8182C9.76425 11.8182 9.53816 11.914 9.37146 12.0844C9.20476 12.2549 9.11111 12.4862 9.11111 12.7273C9.11111 12.9684 9.20476 13.1996 9.37146 13.3701C9.53816 13.5406 9.76425 13.6364 10 13.6364H13.5556C13.7913 13.6364 14.0174 13.5406 14.1841 13.3701C14.3508 13.1996 14.4444 12.9684 14.4444 12.7273C14.4444 12.4862 14.3508 12.2549 14.1841 12.0844C14.0174 11.914 13.7913 11.8182 13.5556 11.8182H10Z"
            fill={props.fill}
        />
    </svg>
);

KnowledgeBaseIcon.defaultProps = {
    width: 20,
    height: 20,
    fill: 'currentColor',
};

export default KnowledgeBaseIcon;
