import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const PaymentsIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 20 20"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M16.7951 2H3.20486C2.09046 2 1.68635 2.11603 1.27894 2.33392C0.87154 2.5518 0.5518 2.87154 0.33392 3.27894C0.11603 3.68635 0 4.09046 0 5.20486V14.7951C0 15.9095 0.11603 16.3136 0.33392 16.7211C0.5518 17.1285 0.87154 17.4482 1.27894 17.6661C1.68635 17.884 2.09046 18 3.20486 18H16.7951C17.9095 18 18.3137 17.884 18.7211 17.6661C19.1285 17.4482 19.4482 17.1285 19.6661 16.7211C19.884 16.3136 20 15.9095 20 14.7951V5.20486C20 4.09046 19.884 3.68635 19.6661 3.27894C19.4482 2.87154 19.1285 2.5518 18.7211 2.33392C18.3137 2.11603 17.9095 2 16.7951 2ZM2.35599 4.04897C2.51125 4.01899 2.77844 4 3.20486 4H16.7951C17.2216 4 17.4887 4.01899 17.644 4.04897C17.7048 4.06072 17.7183 4.06567 17.7779 4.09754C17.8367 4.12903 17.871 4.16327 17.9025 4.22214C17.9343 4.28173 17.9393 4.29517 17.951 4.35599C17.981 4.51125 18 4.77844 18 5.20486V6H2V5.20486C2 4.77844 2.01899 4.51125 2.04897 4.35599C2.06072 4.29517 2.06567 4.28173 2.09754 4.22214C2.12903 4.16327 2.16327 4.12903 2.22214 4.09754C2.28173 4.06567 2.29517 4.06072 2.35599 4.04897ZM2 8V14.7951C2 15.2216 2.01899 15.4887 2.04897 15.644C2.06072 15.7048 2.06567 15.7183 2.09754 15.7779C2.12903 15.8367 2.16327 15.871 2.22214 15.9025C2.28173 15.9343 2.29517 15.9393 2.35599 15.951C2.51125 15.981 2.77844 16 3.20486 16H16.7951C17.2216 16 17.4887 15.981 17.644 15.951C17.7048 15.9393 17.7183 15.9343 17.7779 15.9025C17.8367 15.871 17.871 15.8367 17.9025 15.7779C17.9343 15.7183 17.9393 15.7048 17.951 15.644C17.981 15.4887 18 15.2216 18 14.7951V8H2ZM5 13C4.44772 13 4 12.5523 4 12C4 11.4477 4.44772 11 5 11H8C8.5523 11 9 11.4477 9 12C9 12.5523 8.5523 13 8 13H5Z"
            fill={props.fill}
        />
    </svg>
);

PaymentsIcon.defaultProps = {
    width: 20,
    height: 20,
    fill: 'currentColor',
};

export default PaymentsIcon;
