import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const PrintingIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 20 20"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M5.83366 8.33268C5.66884 8.33268 5.50773 8.38156 5.37068 8.47312C5.23364 8.56469 5.12683 8.69484 5.06376 8.84711C5.00069 8.99938 4.98418 9.16694 5.01634 9.32859C5.04849 9.49024 5.12786 9.63873 5.2444 9.75527C5.36095 9.87182 5.50943 9.95118 5.67108 9.98334C5.83273 10.0155 6.00029 9.99899 6.15256 9.93592C6.30483 9.87284 6.43498 9.76603 6.52655 9.62899C6.61812 9.49195 6.66699 9.33083 6.66699 9.16602C6.66699 8.945 6.5792 8.73304 6.42291 8.57676C6.26663 8.42048 6.05467 8.33268 5.83366 8.33268ZM15.8337 4.99935H15.0003V2.49935C15.0003 2.27834 14.9125 2.06637 14.7562 1.91009C14.6 1.75381 14.388 1.66602 14.167 1.66602H5.83366C5.61265 1.66602 5.40068 1.75381 5.2444 1.91009C5.08812 2.06637 5.00033 2.27834 5.00033 2.49935V4.99935H4.16699C3.50395 4.99935 2.86807 5.26274 2.39923 5.73158C1.93038 6.20042 1.66699 6.83631 1.66699 7.49935V12.4993C1.66699 13.1624 1.93038 13.7983 2.39923 14.2671C2.86807 14.736 3.50395 14.9993 4.16699 14.9993H5.00033V17.4993C5.00033 17.7204 5.08812 17.9323 5.2444 18.0886C5.40068 18.2449 5.61265 18.3327 5.83366 18.3327H14.167C14.388 18.3327 14.6 18.2449 14.7562 18.0886C14.9125 17.9323 15.0003 17.7204 15.0003 17.4993V14.9993H15.8337C16.4967 14.9993 17.1326 14.736 17.6014 14.2671C18.0703 13.7983 18.3337 13.1624 18.3337 12.4993V7.49935C18.3337 6.83631 18.0703 6.20042 17.6014 5.73158C17.1326 5.26274 16.4967 4.99935 15.8337 4.99935ZM6.66699 3.33268H13.3337V4.99935H6.66699V3.33268ZM13.3337 16.666H6.66699V13.3327H13.3337V16.666ZM16.667 12.4993C16.667 12.7204 16.5792 12.9323 16.4229 13.0886C16.2666 13.2449 16.0547 13.3327 15.8337 13.3327H15.0003V12.4993C15.0003 12.2783 14.9125 12.0664 14.7562 11.9101C14.6 11.7538 14.388 11.666 14.167 11.666H5.83366C5.61265 11.666 5.40068 11.7538 5.2444 11.9101C5.08812 12.0664 5.00033 12.2783 5.00033 12.4993V13.3327H4.16699C3.94598 13.3327 3.73402 13.2449 3.57774 13.0886C3.42146 12.9323 3.33366 12.7204 3.33366 12.4993V7.49935C3.33366 7.27834 3.42146 7.06637 3.57774 6.91009C3.73402 6.75381 3.94598 6.66602 4.16699 6.66602H15.8337C16.0547 6.66602 16.2666 6.75381 16.4229 6.91009C16.5792 7.06637 16.667 7.27834 16.667 7.49935V12.4993Z"
            fill={props.fill}
        />
    </svg>
);

PrintingIcon.defaultProps = {
    width: 20,
    height: 20,
    fill: 'currentColor',
};

export default PrintingIcon;
