import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SortingUpIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 20 20"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M10.763 15.2016C10.763 15.6407 10.4196 16 10 16C9.58035 16 9.23701 15.6407 9.23701 15.2016V8.07876C9.23701 7.47648 9.30217 6.87667 9.43081 6.29091L9.27386 6.12557L9.10966 6.40037C8.80385 6.91188 8.44364 7.38554 8.0359 7.81219L7.299 8.58324C7.00143 8.8946 6.52074 8.8946 6.22318 8.58324C5.92561 8.27188 5.92561 7.76093 6.22318 7.44957L9.19153 4.34986C9.63834 3.88338 10.3617 3.88338 10.8085 4.34986L13.7768 7.44957C14.0744 7.76093 14.0744 8.27188 13.7768 8.58324C13.4793 8.8946 12.9986 8.8946 12.701 8.58324L11.9641 7.81219C11.5563 7.38554 11.1961 6.91188 10.8903 6.40037L10.7261 6.12557L10.5692 6.29091C10.6978 6.87667 10.763 7.47648 10.763 8.07876V15.2016Z"
            fill={props.fill}
        />
    </svg>
);

SortingUpIcon.defaultProps = {
    width: 20,
    height: 20,
    fill: 'currentColor',
};

export default SortingUpIcon;
