import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const WarningFilledIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 20 20"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M10 20C15.523 20 20 15.523 20 10C20 4.477 15.523 0 10 0C4.477 0 0 4.477 0 10C0 15.523 4.477 20 10 20ZM8.5 14.991C8.5 14.124 9.159 13.5 9.991 13.5C10.841 13.5 11.5 14.124 11.5 14.991C11.5 15.858 10.841 16.5 9.991 16.5C9.159 16.5 8.5 15.858 8.5 14.991ZM9.172 4C9.10453 4.00007 9.03777 4.01379 8.97575 4.04035C8.91372 4.0669 8.85771 4.10573 8.81109 4.1545C8.76447 4.20327 8.7282 4.26097 8.70447 4.32413C8.68073 4.38729 8.67003 4.4546 8.673 4.522L8.979 11.522C8.98467 11.6508 9.03984 11.7724 9.133 11.8614C9.22616 11.9505 9.35012 12.0001 9.479 12H10.522C10.6509 12.0001 10.7748 11.9505 10.868 11.8614C10.9612 11.7724 11.0163 11.6508 11.022 11.522L11.327 4.522C11.33 4.45451 11.3192 4.38712 11.2954 4.3239C11.2717 4.26067 11.2353 4.20292 11.1886 4.15414C11.1418 4.10535 11.0857 4.06654 11.0236 4.04005C10.9614 4.01356 10.8946 3.99993 10.827 4H9.172Z"
            fill={props.fill}
        />
    </svg>
);

WarningFilledIcon.defaultProps = {
    width: 20,
    height: 20,
    fill: 'currentColor',
};

export default WarningFilledIcon;
