import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const WebLayoutIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 20 20"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M17.5001 1.66602H2.50008C2.27907 1.66602 2.06711 1.75381 1.91083 1.91009C1.75455 2.06637 1.66675 2.27834 1.66675 2.49935V17.4993C1.66675 17.7204 1.75455 17.9323 1.91083 18.0886C2.06711 18.2449 2.27907 18.3327 2.50008 18.3327H17.5001C17.7211 18.3327 17.9331 18.2449 18.0893 18.0886C18.2456 17.9323 18.3334 17.7204 18.3334 17.4993V2.49935C18.3334 2.27834 18.2456 2.06637 18.0893 1.91009C17.9331 1.75381 17.7211 1.66602 17.5001 1.66602ZM11.6667 16.666H3.33341V10.8327H11.6667V16.666ZM11.6667 9.16601H3.33341V3.33268H11.6667V9.16601ZM16.6667 16.666H13.3334V3.33268H16.6667V16.666Z"
            fill={props.fill}
        />
    </svg>
);

WebLayoutIcon.defaultProps = {
    width: 20,
    height: 20,
    fill: 'currentColor',
};

export default WebLayoutIcon;
