import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const AcIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M22 17C23.1046 17 24 16.1046 24 15V5C24 3.89543 23.1046 3 22 3H2C0.895431 3 0 3.89543 0 5V15C0 16.1046 0.89543 17 2 17H4V14C4 13.4477 4.44772 13 5 13H19C19.5523 13 20 13.4477 20 14V17H22ZM4.5 10C4.22386 10 4 10.2239 4 10.5C4 10.7761 4.22386 11 4.5 11H19.5C19.7761 11 20 10.7761 20 10.5C20 10.2239 19.7761 10 19.5 10H4.5ZM19 6C18.4477 6 18 6.44772 18 7C18 7.55228 18.4477 8 19 8C19.5523 8 20 7.55228 20 7C20 6.44772 19.5523 6 19 6Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8.16093 19.7831C8.16093 20.1434 8.68304 20.7948 8.27398 20.9513C7.93483 21.0811 7.70873 20.9513 7.36958 20.5619C7.14348 20.3023 6.80433 19.9129 7.14348 19.2639C7.25653 19.0043 8.61312 17.966 8.61312 17.4468C8.61312 16.9276 7.70873 16.1488 7.48263 15.8892C7.25653 15.6296 7.33745 15.2586 7.59568 15.1104C8.27398 14.721 9.96972 15.8892 9.96972 17.1872C9.96972 18.5972 8.16093 19.2639 8.16093 19.7831Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M11.7651 19.7831C11.7651 20.1434 12.2872 20.7948 11.8781 20.9513C11.539 21.0811 11.3129 20.9513 10.9737 20.5619C10.7476 20.3023 10.4085 19.9129 10.7476 19.2639C10.8607 19.0043 12.2173 17.966 12.2173 17.4468C12.2173 16.9276 11.3129 16.1488 11.0868 15.8892C10.8607 15.6296 10.9416 15.2586 11.1998 15.1104C11.8781 14.721 13.5738 15.8892 13.5738 17.1872C13.5738 18.5972 11.7651 19.2639 11.7651 19.7831Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M15.3692 19.7831C15.3692 20.1434 15.8913 20.7948 15.4822 20.9513C15.1431 21.0811 14.917 20.9513 14.5778 20.5619C14.3517 20.3023 14.0126 19.9129 14.3517 19.2639C14.4648 19.0043 15.8214 17.966 15.8214 17.4468C15.8214 16.9276 14.917 16.1488 14.6909 15.8892C14.4648 15.6296 14.5457 15.2586 14.8039 15.1104C15.4822 14.721 17.178 15.8892 17.178 17.1872C17.178 18.5972 15.3692 19.2639 15.3692 19.7831Z"
            fill={props.fill}
        />
    </svg>
);

AcIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default AcIcon;
