import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const AlarmOffIcon = (props: IIconProps): ReactElement => (
    <svg viewBox="0 0 24 24" fill="none" focusable={false} {...props}>
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M2.76 8.168A3.581 3.581 0 011 5.087C1 3.106 2.615 1.5 4.607 1.5c1.225 0 2.307.607 2.959 1.534A9.96 9.96 0 0112 2c1.592 0 3.098.372 4.434 1.034A3.609 3.609 0 0119.393 1.5C21.385 1.5 23 3.106 23 5.087c0 1.31-.706 2.455-1.76 3.081a9.97 9.97 0 01.712 4.823 6.463 6.463 0 00-1.954-.817L20 12a8 8 0 10-7.826 7.998c.165.702.444 1.36.817 1.953-.326.033-.657.049-.991.049-5.523 0-10-4.477-10-10 0-1.357.27-2.652.76-3.832zm.98-1.807a10.057 10.057 0 012.083-2.225 1.55 1.55 0 00-1.216-.586c-.854 0-1.546.688-1.546 1.537 0 .522.265.994.68 1.274zm16.52 0c.414-.28.679-.752.679-1.274 0-.85-.692-1.537-1.546-1.537a1.55 1.55 0 00-1.216.586c.802.63 1.505 1.381 2.082 2.225zM8 12a1 1 0 011-1h2V7a1 1 0 112 0v4a2 2 0 01-2 2H9a1 1 0 01-1-1z"
            fill="#000"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M24 18.5a5.5 5.5 0 11-11 0 5.5 5.5 0 0111 0zm-2.676 2.837a1 1 0 000-1.414l-1.414-1.414 1.414-1.414a1 1 0 10-1.414-1.414l-1.414 1.414-1.415-1.415a1 1 0 10-1.414 1.415l1.414 1.414-1.414 1.414a1 1 0 001.414 1.414l1.415-1.414 1.414 1.414a1 1 0 001.414 0z"
            fill="#000"
        />
    </svg>
);

AlarmOffIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default AlarmOffIcon;
