import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BathroomIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M16.9998 2.49997C16.9998 3.32839 16.3283 3.99996 15.4998 3.99996C14.6714 3.99996 13.9999 3.32839 13.9999 2.49997C13.9999 1.67156 14.6714 0.99999 15.4998 0.99999C16.3283 0.99999 16.9998 1.67156 16.9998 2.49997Z"
            fill={props.fill}
        />
        <path
            d="M12.4999 6.99993C13.3283 6.99993 13.9999 6.32836 13.9999 5.49994C13.9999 4.67153 13.3283 3.99996 12.4999 3.99996C11.6715 3.99996 10.9999 4.67153 10.9999 5.49994C10.9999 6.32836 11.6715 6.99993 12.4999 6.99993Z"
            fill={props.fill}
        />
        <path
            d="M19.9998 6.99993C19.9998 8.10449 19.1044 8.99991 17.9998 8.99991C16.8953 8.99991 15.9998 8.10449 15.9998 6.99993C15.9998 5.89537 16.8953 4.99995 17.9998 4.99995C19.1044 4.99995 19.9998 5.89537 19.9998 6.99993Z"
            fill={props.fill}
        />
        <path
            d="M0.99999 8.99991C5.24091 8.99991 8.19604 9.67445 11.8033 11.1312C12.2248 11.3014 13.7004 11.9156 13.5966 11.8727C14.3058 12.1654 14.8326 12.3718 15.3543 12.556C18.0554 13.5103 20.3447 13.6944 23.2423 12.97C23.7781 12.8361 24.1038 12.2931 23.9699 11.7573C23.836 11.2216 23.293 10.8958 22.7572 11.0297C20.2648 11.6528 18.3705 11.5005 16.0204 10.6703C15.5374 10.4997 15.0395 10.3046 14.3594 10.024C14.4722 10.0705 12.9853 9.45164 12.5522 9.27675C8.72332 7.73048 5.52282 6.99993 0.99999 6.99993C0.447711 6.99993 0 7.44764 0 7.99992C0 8.5522 0.447711 8.99991 0.99999 8.99991Z"
            fill={props.fill}
        />
        <path
            d="M1.99998 9.9999C6.82902 9.9999 9.79247 11.2825 12.4669 12.44C15.3307 13.6795 17.8631 14.7755 21.9998 13.9999C21.9998 17.4813 21.0104 19.2312 19.2776 20.1108L19.4998 20.9998H19.9998C20.5521 20.9998 20.9998 21.4475 20.9998 21.9998V22.4998C20.9998 22.7759 20.7759 22.9998 20.4998 22.9998H18.9998C18.6851 22.9998 18.3887 22.8516 18.1998 22.5998L17.7498 21.9998C17.2777 21.3703 16.5367 20.9998 15.7498 20.9998H8.24992C7.46303 20.9998 6.72207 21.3703 6.24994 21.9998L5.79994 22.5998C5.61109 22.8516 5.3147 22.9998 4.99995 22.9998H3.49996C3.22382 22.9998 2.99997 22.7759 2.99997 22.4998V21.9998C2.99997 21.4475 3.44768 20.9998 3.99996 20.9998H4.49995L4.81058 19.7573C4.81654 19.7335 4.82332 19.71 4.83088 19.687C3.03083 18.3334 1.99998 15.5841 1.99998 9.9999Z"
            fill={props.fill}
        />
    </svg>
);

BathroomIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default BathroomIcon;
