import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BurgerIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <rect x={3} y={11} width={18} height={2} rx={1} fill={props.fill} />
        <rect x={3} y={5} width={18} height={2} rx={1} fill={props.fill} />
        <rect x={3} y={17} width={18} height={2} rx={1} fill={props.fill} />
    </svg>
);

BurgerIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default BurgerIcon;
