import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BusIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M15.5627 4.31989C16.2489 4.44411 16.929 4.60428 17.6 4.8C18.0063 4.92779 18.3613 5.18197 18.6131 5.52552C18.8649 5.86907 19.0005 6.28404 19 6.71V11C19 11 19 13 16 13H8C5.01625 13 5.00009 11.0216 5 11.0002V6.71C4.99955 6.28404 5.1351 5.86907 5.38692 5.52552C5.63874 5.18197 5.99367 4.92779 6.4 4.8C7.07103 4.60428 7.75107 4.44411 8.43726 4.31989L8.54 4.63C8.67246 5.02911 8.92735 5.37631 9.26845 5.62226C9.60954 5.86821 10.0195 6.00038 10.44 6H13.56C13.9805 6.00038 14.3905 5.86821 14.7316 5.62226C15.0726 5.37631 15.3275 5.02911 15.46 4.63L15.5627 4.31989ZM12 2C9.91535 2 7.84127 2.2963 5.84 2.88C5.01823 3.12901 4.29841 3.63586 3.78696 4.32559C3.27551 5.01533 2.99959 5.85133 3 6.71V22H6.94L7.94 20H16.08L17.08 22H21V6.71C21.0004 5.85133 20.7245 5.01533 20.213 4.32559C19.7016 3.63586 18.9818 3.12901 18.16 2.88C16.1587 2.2963 14.0847 2 12 2ZM5 15V17H9C9 16.4696 8.78929 15.9609 8.41422 15.5858C8.03914 15.2107 7.53043 15 7 15H5ZM19 17V15H17C16.4696 15 15.9609 15.2107 15.5858 15.5858C15.2107 15.9609 15 16.4696 15 17H19Z"
            fill={props.fill}
        />
    </svg>
);

BusIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default BusIcon;
