import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CheckIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M7.20486 2H16.7951C17.9095 2 18.3136 2.11603 18.7211 2.33392C19.1285 2.5518 19.4482 2.87154 19.6661 3.27894C19.884 3.68635 20 4.09046 20 5.20486V20.8L18 20.5V5.20486C18 4.77844 17.981 4.51125 17.951 4.35599C17.9393 4.29517 17.9343 4.28173 17.9025 4.22214C17.871 4.16327 17.8367 4.12903 17.7779 4.09754C17.7183 4.06567 17.7048 4.06072 17.644 4.04897C17.4887 4.01899 17.2216 4 16.7951 4H7.20486C6.77844 4 6.51125 4.01899 6.35599 4.04897C6.29517 4.06072 6.28173 4.06567 6.22214 4.09754C6.16327 4.12903 6.12903 4.16327 6.09754 4.22214C6.06567 4.28173 6.06072 4.29517 6.04897 4.35599C6.01899 4.51125 6 4.77844 6 5.20486V20.5L4 20.8V5.20486C4 4.09046 4.11603 3.68635 4.33392 3.27894C4.5518 2.87154 4.87154 2.5518 5.27894 2.33392C5.68635 2.11603 6.09046 2 7.20486 2Z"
            fill={props.fill}
        />
        <rect x={8} y={6} width={8} height={2} rx={1} fill={props.fill} />
        <rect x={8} y={10} width={8} height={2} rx={1} fill={props.fill} />
        <rect x={13} y={14} width={3} height={2} rx={1} fill={props.fill} />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6.7429 18.48C7.14925 18.1753 7.70797 18.1753 8.11432 18.48L9.7143 19.68L11.3143 18.48C11.7206 18.1753 12.2794 18.1753 12.6857 18.48L14.2857 19.68L15.8857 18.48C16.292 18.1753 16.8508 18.1763 17.2571 18.481L19.5428 20.1915C20.0477 20.5702 20.1501 20.7879 19.7714 21.2929C19.3927 21.7978 18.6763 21.9001 18.1714 21.5214L16.5714 20.3214L14.9714 21.5214C14.5651 21.8262 14.0063 21.8262 13.6 21.5214L12 20.3214L10.4 21.5214C9.99367 21.8262 9.43494 21.8262 9.0286 21.5214L7.42861 20.3214L5.82862 21.5214C5.32368 21.9001 4.60734 21.7978 4.22864 21.2929C3.84993 20.7879 3.95226 20.5687 4.45721 20.19L6.7429 18.48Z"
            fill={props.fill}
        />
    </svg>
);

CheckIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default CheckIcon;
