import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CheckCircleIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M22 12C22 17.523 17.523 22 12 22C6.477 22 2 17.523 2 12C2 6.477 6.477 2 12 2C17.523 2 22 6.477 22 12ZM17.1638 7.75296C16.9656 7.57699 16.7057 7.4869 16.4411 7.50246C16.1766 7.51802 15.929 7.63797 15.7528 7.83596L10.4858 13.761L8.23481 11.321C8.05486 11.126 7.80484 11.0106 7.53976 11C7.27467 10.9894 7.01624 11.0845 6.82131 11.2645C6.62637 11.4444 6.51091 11.6944 6.50031 11.9595C6.48972 12.2246 6.58486 12.483 6.76481 12.678L9.39081 15.523C9.52441 15.6678 9.68523 15.7848 9.86409 15.8675C10.0429 15.9501 10.2363 15.9967 10.4332 16.0046C10.6301 16.0125 10.8266 15.9816 11.0115 15.9135C11.1964 15.8454 11.366 15.7416 11.5108 15.608L11.5638 15.556C11.5808 15.5382 11.5974 15.5202 11.6138 15.502L17.2468 9.16396C17.4228 8.96578 17.5129 8.70585 17.4973 8.44128C17.4817 8.17671 17.3618 7.92914 17.1638 7.75296Z"
            fill={props.fill}
        />
    </svg>
);

CheckCircleIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default CheckCircleIcon;
