import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DetailsIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M4 7C4 6.44772 4.44772 6 5 6H13C13.5523 6 14 6.44772 14 7C14 7.55228 13.5523 8 13 8H5C4.44772 8 4 7.55228 4 7ZM5 11C4.44772 11 4 11.4477 4 12C4 12.5523 4.44772 13 5 13H13C13.5523 13 14 12.5523 14 12C14 11.4477 13.5523 11 13 11H5ZM5 16C4.44772 16 4 16.4477 4 17C4 17.5523 4.44772 18 5 18H13C13.5523 18 14 17.5523 14 17C14 16.4477 13.5523 16 13 16H5ZM18 16C17.4477 16 17 16.4477 17 17C17 17.5523 17.4477 18 18 18H19C19.5523 18 20 17.5523 20 17C20 16.4477 19.5523 16 19 16H18ZM17 12C17 11.4477 17.4477 11 18 11H19C19.5523 11 20 11.4477 20 12C20 12.5523 19.5523 13 19 13H18C17.4477 13 17 12.5523 17 12ZM18 6C17.4477 6 17 6.44772 17 7C17 7.55228 17.4477 8 18 8H19C19.5523 8 20 7.55228 20 7C20 6.44772 19.5523 6 19 6H18Z"
            fill={props.fill}
        />
    </svg>
);

DetailsIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default DetailsIcon;
