import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DisabledIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M9.00005 5C10.1046 5 11.0001 4.10457 11.0001 3C11.0001 1.89543 10.1046 1 9.00005 1C7.89548 1 7.00005 1.89543 7.00005 3C7.00005 4.10457 7.89548 5 9.00005 5Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6.25198 13.5986L6.86173 14.9811C7.00626 15.3088 6.87308 15.6924 6.55662 15.8601C6.25516 16.0198 5.88207 15.9326 5.6827 15.6557L2.91198 11.8082C2.90058 11.7924 2.89665 11.7744 2.90279 11.7558C3.01374 11.4213 4.13924 8.09074 5.35054 6.92371C6.62648 5.69438 8.98492 4.85312 9.96233 6.53485C10.6248 7.67475 10.998 9.75449 11.1697 10.9763C10.5977 10.8571 9.98969 10.8823 9.40146 11.0756C9.87515 11.0861 10.3408 11.1531 10.7899 11.2715C11.8618 11.5541 12.8393 12.1299 13.6062 12.9319C13.3671 12.3997 13.0074 11.9564 12.5727 11.6214H16.4533C16.4852 11.6214 16.5131 11.6429 16.5212 11.6737L18.0948 17.659C18.2072 18.0864 17.953 18.5243 17.5261 18.6387C17.1336 18.7438 16.7244 18.5391 16.5732 18.1619L14.9571 14.1308C14.9543 14.1241 14.9481 14.1198 14.9408 14.1201C14.8936 14.1222 14.7099 14.1301 14.4958 14.133C14.7364 14.5614 14.9278 15.0264 15.0608 15.5227C15.7762 18.1924 14.5734 20.9243 12.2972 22.2549C13.4325 22.082 14.4676 21.3872 15.0342 20.3046L20.7325 18.7739C20.8675 18.7376 21.0001 18.8393 21.0001 18.979V23.8416C21.0001 23.9291 20.9291 24 20.8416 24H5.56604C5.25345 24 5.00005 23.7466 5.00005 23.434C5.00005 23.178 5.17194 22.9538 5.41921 22.8874L6.75934 22.5274C5.19478 21.8072 3.95032 20.4222 3.4697 18.6285C3.08606 17.2935 3.38293 15.8852 3.53262 15.3287C3.56653 15.2026 3.71182 15.1516 3.821 15.2232L4.69981 15.7998C4.77282 15.8477 4.80683 15.937 4.7883 16.0223C4.71247 16.3715 4.55687 17.3131 4.822 18.2662C5.47953 20.7201 8.00188 22.1764 10.4558 21.5189C12.9098 20.8613 14.366 18.339 13.7085 15.885C13.051 13.4311 10.5286 11.9748 8.07469 12.6323C7.37826 12.8189 6.76219 13.1558 6.25198 13.5986ZM5.66703 12.2723C6.07574 11.9659 6.52855 11.7086 7.01907 11.5113C6.86741 11.1278 6.67834 10.6619 6.53866 10.3579C6.26499 9.76239 6.03059 9.46169 6.03059 9.46169C6.03059 9.46169 5.77428 10.0801 5.65835 10.3579C5.54775 10.623 5.24939 11.2024 5.22215 11.2552C5.22074 11.2579 5.22086 11.2607 5.2221 11.2635L5.66703 12.2723Z"
            fill={props.fill}
        />
    </svg>
);

DisabledIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default DisabledIcon;
