import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DownloadIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M11.4571 17.6794C11.7527 17.9899 12.248 17.9899 12.5436 17.6794L17.1461 12.8448C17.4492 12.5264 17.2236 12 16.784 12H14.0004V4C14.0004 3.44772 13.5526 3 13.0004 3H11.0004C10.4481 3 10.0004 3.44772 10.0004 4V12H7.2167C6.77715 12 6.55149 12.5264 6.85456 12.8448L11.4571 17.6794ZM5 19C4.44772 19 4 19.4477 4 20C4 20.5523 4.44772 21 5 21H19C19.5523 21 20 20.5523 20 20C20 19.4477 19.5523 19 19 19H5Z"
            fill={props.fill}
        />
    </svg>
);

DownloadIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default DownloadIcon;
