import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const FireIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <rect x={2} y={2} width={20} height={20} rx={10} fill={props.fill} />
        <path
            d="M9.60049 19C7.93844 13.8718 11.4503 11.9994 11.4503 11.9994C11.2046 14.7358 12.8653 16.8677 12.8653 16.8677C13.4761 16.6952 14.642 15.8887 14.642 15.8887C14.642 16.8677 14.0268 18.9988 14.0268 18.9988C14.0268 18.9988 16.1803 17.4396 16.8582 14.8501C17.5352 12.2605 15.5686 9.66068 15.5686 9.66068C15.6871 11.4935 15.0249 13.2962 13.7275 14.6734C13.7924 14.6033 13.8469 14.5253 13.8887 14.4409C14.1218 14.0044 14.496 12.8699 14.2769 10.2428C13.9684 6.55506 10.3999 5 10.3999 5C10.7075 7.24692 9.78521 7.76459 7.62476 12.0296C5.46432 16.2937 9.60049 19 9.60049 19Z"
            fill="white"
        />
    </svg>
);

FireIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default FireIcon;
