import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const FlightIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M20.9999 1.62029C21.7399 1.39029 22.3099 1.36029 22.4999 1.55029C22.6899 1.74029 22.6599 2.31028 22.4299 3.05028C21.9369 4.55211 21.1055 5.92062 19.9999 7.05026L17.9999 9.05025L18.9999 22.0502L17.9999 23.0502L13.6231 13.4211C12.8067 14.205 11.9296 14.9237 10.9999 15.5702C10.4417 16.0016 9.85336 16.3898 9.24026 16.7323L9.99995 22.0502L8.99995 23.0502L5.99997 18.0502L0.999995 15.0502L1.99999 14.0502L7.32418 14.8108C7.66569 14.1982 8.05177 13.6096 8.47996 13.0502C9.22994 11.978 10.0732 10.9741 10.9999 10.0502L16.9999 4.05027C18.1296 2.94464 19.4981 2.11326 20.9999 1.62029ZM1.99999 5.05027L0.999995 6.05027L9.38995 9.86025C10.5479 8.44318 11.8187 7.1222 13.1899 5.91027L1.99999 5.05027Z"
            fill={props.fill}
        />
    </svg>
);

FlightIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default FlightIcon;
