import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const FoodAndBeverageIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M14 4C14 5.10457 13.1046 6 12 6C10.8954 6 10 5.10457 10 4C10 2.89543 10.8954 2 12 2C13.1046 2 14 2.89543 14 4Z"
            fill={props.fill}
        />
        <path
            d="M2.57143 16.6818C0.97492 14.9545 0 13.7254 0 11.5C0 9.11513 1.91878 7.18182 4.28571 7.18182C5.0334 7.18182 5.73638 7.37474 6.34827 7.71387C5.91567 8.08135 5.50765 8.4826 5.12754 8.90909H4.28571C2.86555 8.90909 1.71429 10.0691 1.71429 11.5C1.71429 12.8911 2.80244 14.0262 4.16794 14.0882C5.10779 10.8855 7.71848 7 12 7C18.8571 7 21.4286 16.6818 19.7143 18.4091C18 20.1364 15 21 12 21C9 21 6 20.1364 4.28571 18.4091C4.14917 18.2715 4.0853 18.2183 4.01632 18.1609C3.86038 18.031 3.67831 17.8794 2.57143 16.6818Z"
            fill={props.fill}
        />
        <path
            d="M21.3931 16.8236C22.6564 15.5355 23.5253 12.2609 24 7H22.2857L19.2481 10.0607C20.764 12.342 21.479 15.0119 21.3931 16.8236Z"
            fill={props.fill}
        />
    </svg>
);

FoodAndBeverageIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default FoodAndBeverageIcon;
