import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const GiftOutlineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M12.1135 4.43347C12.9091 3.27612 14.3031 2 16.5 2C17.3649 2 18.2276 2.27303 18.8925 2.80492C19.5631 3.34144 20 4.12317 20 5C20 5.38876 19.9141 5.75883 19.7601 6.09712C21.0489 6.43364 22 7.60574 22 9C22 10.3113 21.1586 11.4262 19.9863 11.8341C19.9953 11.8881 20 11.9435 20 12V20C20 20.5523 19.5523 21 19 21H5C4.44772 21 4 20.5523 4 20V12C4 11.9435 4.00469 11.8881 4.0137 11.8341C2.84136 11.4262 2 10.3113 2 9C2 7.60574 2.95113 6.43364 4.23994 6.09712C4.08588 5.75883 4 5.38876 4 5C4 4.12317 4.43688 3.34144 5.10754 2.80492C5.7724 2.27303 6.63506 2 7.5 2C9.69693 2 11.0909 3.27612 11.8865 4.43347C11.9256 4.4903 11.9634 4.54707 12 4.60363C12.0366 4.54707 12.0744 4.4903 12.1135 4.43347ZM10.5071 6C10.4276 5.85766 10.3383 5.71168 10.2385 5.56653C9.65914 4.72388 8.80307 4 7.5 4C7.03885 4 6.62975 4.1484 6.35693 4.36666C6.0899 4.58028 6 4.81597 6 5C6 5.18403 6.0899 5.41972 6.35693 5.63334C6.62975 5.8516 7.03885 6 7.5 6H10.5071ZM7.5 8H5C4.44772 8 4 8.44772 4 9C4 9.55229 4.44772 10 5 10H19C19.5523 10 20 9.55228 20 9C20 8.44772 19.5523 8 19 8H16.5H12H7.5ZM17.6431 5.63334C17.3703 5.8516 16.9611 6 16.5 6H13.4929C13.5724 5.85766 13.6617 5.71168 13.7615 5.56653C14.3409 4.72388 15.1969 4 16.5 4C16.9611 4 17.3703 4.1484 17.6431 4.36666C17.9101 4.58028 18 4.81597 18 5C18 5.18403 17.9101 5.41972 17.6431 5.63334ZM6 12V19H18V12H6Z"
            fill={props.fill}
        />
    </svg>
);

GiftOutlineIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default GiftOutlineIcon;
