import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const GlobeIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M2 12C2 17.5228 6.47715 22 12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12ZM12 4.14286C10.4189 4.14286 8.94683 4.60989 7.71429 5.41352V6.57143C7.71429 7.20261 8.22596 7.71429 8.85714 7.71429H13.7143C14.3455 7.71429 14.8571 8.22596 14.8571 8.85714V10.098C14.8571 10.4011 14.9776 10.6918 15.1919 10.9062L15.7033 11.4175C16.0511 11.7654 16.5825 11.8516 17.0225 11.6316L18.5111 10.8873C18.8983 10.6937 19.1429 10.298 19.1429 9.8651V8.72216C17.9006 6.01947 15.1694 4.14286 12 4.14286ZM10.2696 19.666C10.8264 19.7911 11.4055 19.8571 12 19.8571C12.1849 19.8571 12.3682 19.8508 12.5499 19.8382L15.691 15.6501C16.0322 15.1951 15.987 14.5584 15.5848 14.1563L12.3347 10.9062C12.1204 10.6918 11.8297 10.5714 11.5266 10.5714H7.10944C6.61752 10.5714 6.18079 10.8862 6.02523 11.3529L5.21855 13.7729C5.01895 14.3717 5.34256 15.0189 5.94135 15.2185L8.60075 16.105C8.94202 16.2188 9.20981 16.4866 9.32356 16.8278L10.2696 19.666Z"
            fill={props.fill}
        />
    </svg>
);

GlobeIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default GlobeIcon;
