import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HandLuggage5Icon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6.00001 8.15137C3.79087 8.15137 2.00001 9.94222 2.00001 12.1514L2 16.001C1.99999 18.2101 3.79086 20.001 6 20.001H18C20.2091 20.001 22 18.2101 22 16.001L22 12.1514C22 9.94223 20.2092 8.15137 18 8.15137H6.00001ZM14.023 15.8303C14.143 15.5543 14.203 15.2483 14.203 14.9123C14.203 14.5823 14.152 14.2913 14.05 14.0393C13.954 13.7813 13.816 13.5653 13.636 13.3913C13.462 13.2173 13.252 13.0853 13.006 12.9953C12.76 12.9053 12.487 12.8603 12.187 12.8603C11.917 12.8603 11.695 12.8933 11.521 12.9593C11.347 13.0253 11.203 13.1003 11.089 13.1843V11.5463H13.879V10.6193H10.153V14.0933H10.963C11.041 13.9973 11.158 13.9103 11.314 13.8323C11.47 13.7543 11.674 13.7153 11.926 13.7153C12.298 13.7153 12.586 13.8203 12.79 14.0303C13 14.2403 13.105 14.5463 13.105 14.9483C13.105 15.3383 12.985 15.6593 12.745 15.9113C12.511 16.1573 12.175 16.2803 11.737 16.2803C11.341 16.2803 11.005 16.2203 10.729 16.1003C10.453 15.9803 10.21 15.8453 10 15.6953V16.7033C10.204 16.8353 10.447 16.9463 10.729 17.0363C11.017 17.1203 11.368 17.1623 11.782 17.1623C12.148 17.1623 12.478 17.1083 12.772 17.0003C13.072 16.8923 13.327 16.7393 13.537 16.5413C13.747 16.3433 13.909 16.1063 14.023 15.8303Z"
            fill={props.fill}
        />
        <path
            d="M8.50398 6.77629L8.49683 6.88298H8.60376H9.35206H9.44362L9.45167 6.79178C9.55782 5.5907 10.6003 4.894 11.8963 4.894C13.1918 4.894 14.2358 5.59061 14.3598 6.79324L14.369 6.88298H14.4592H15.2075H15.3157L15.3072 6.77519C15.2394 5.90783 14.8312 5.23633 14.2144 4.78375C13.5997 4.3327 12.7826 4.10209 11.8963 4.10209C11.0101 4.10209 10.1928 4.33268 9.58038 4.78386C8.96573 5.23666 8.56213 5.90856 8.50398 6.77629Z"
            fill={props.fill}
            stroke={props.fill}
            strokeWidth={0.2}
        />
    </svg>
);

HandLuggage5Icon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default HandLuggage5Icon;
