import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HandLuggage8Icon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6.00001 8.15137C3.79087 8.15137 2.00001 9.94222 2.00001 12.1514L2 16.001C1.99999 18.2101 3.79086 20.001 6 20.001H18C20.2091 20.001 22 18.2101 22 16.001L22 12.1514C22 9.94223 20.2092 8.15137 18 8.15137H6.00001ZM13.955 16.053C14.075 15.819 14.135 15.558 14.135 15.27C14.135 14.862 14.024 14.523 13.802 14.253C13.58 13.977 13.28 13.773 12.902 13.641C13.214 13.515 13.46 13.329 13.64 13.083C13.826 12.837 13.919 12.531 13.919 12.165C13.919 11.895 13.865 11.655 13.757 11.445C13.649 11.235 13.502 11.061 13.316 10.923C13.13 10.785 12.908 10.68 12.65 10.608C12.392 10.536 12.116 10.5 11.822 10.5C11.522 10.5 11.243 10.539 10.985 10.617C10.727 10.689 10.505 10.797 10.319 10.941C10.133 11.079 9.986 11.253 9.878 11.463C9.776 11.673 9.725 11.913 9.725 12.183C9.725 12.543 9.815 12.846 9.995 13.092C10.181 13.338 10.427 13.521 10.733 13.641C10.355 13.779 10.055 13.989 9.833 14.271C9.611 14.547 9.5 14.889 9.5 15.297C9.5 15.585 9.557 15.843 9.671 16.071C9.785 16.293 9.944 16.485 10.148 16.647C10.358 16.803 10.604 16.923 10.886 17.007C11.174 17.085 11.486 17.124 11.822 17.124C12.152 17.124 12.458 17.082 12.74 16.998C13.022 16.914 13.265 16.794 13.469 16.638C13.679 16.476 13.841 16.281 13.955 16.053ZM12.578 12.993C12.386 13.155 12.134 13.236 11.822 13.236C11.516 13.236 11.264 13.155 11.066 12.993C10.868 12.831 10.769 12.6 10.769 12.3C10.769 12.006 10.868 11.778 11.066 11.616C11.264 11.448 11.516 11.364 11.822 11.364C12.134 11.364 12.386 11.448 12.578 11.616C12.776 11.778 12.875 12.006 12.875 12.3C12.875 12.6 12.776 12.831 12.578 12.993ZM12.704 15.972C12.476 16.158 12.182 16.251 11.822 16.251C11.456 16.251 11.156 16.158 10.922 15.972C10.688 15.78 10.571 15.504 10.571 15.144C10.571 14.784 10.688 14.508 10.922 14.316C11.156 14.124 11.456 14.028 11.822 14.028C12.182 14.028 12.476 14.124 12.704 14.316C12.938 14.508 13.055 14.784 13.055 15.144C13.055 15.504 12.938 15.78 12.704 15.972Z"
            fill={props.fill}
        />
        <path
            d="M8.50398 6.77629L8.49683 6.88298H8.60376H9.35206H9.44362L9.45167 6.79178C9.55782 5.5907 10.6003 4.894 11.8963 4.894C13.1918 4.894 14.2358 5.59061 14.3598 6.79324L14.369 6.88298H14.4592H15.2075H15.3157L15.3072 6.77519C15.2394 5.90783 14.8312 5.23633 14.2144 4.78375C13.5997 4.3327 12.7826 4.10209 11.8963 4.10209C11.0101 4.10209 10.1928 4.33268 9.58038 4.78386C8.96573 5.23666 8.56213 5.90856 8.50398 6.77629Z"
            fill={props.fill}
            stroke={props.fill}
            strokeWidth={0.2}
        />
    </svg>
);

HandLuggage8Icon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default HandLuggage8Icon;
