import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HeartFilledIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M12.39 20.8701C12.2749 20.948 12.139 20.9896 12 20.9896C11.861 20.9896 11.7251 20.948 11.61 20.8701C9.764 19.6371 2 14.1501 2 8.97305C2 2.29305 9.85 1.22305 12 5.72305C14.15 1.22305 22 2.29305 22 8.97305C22 14.1511 14.236 19.6371 12.39 20.8681V20.8701Z"
            fill={props.fill}
        />
    </svg>
);

HeartFilledIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default HeartFilledIcon;
