import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HeartOutlineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M12.509 20.86C18.78 17.154 22 13.22 22 9.00002C22 2.99802 15.251 1.11002 12 5.10202C8.749 1.11002 2 2.99802 2 9.00002C2 13.22 5.219 17.153 11.491 20.86C11.6451 20.9512 11.8209 20.9993 12 20.9993C12.1791 20.9993 12.3549 20.9512 12.509 20.86ZM12.911 7.41202C14.677 3.51002 20 4.54202 20 9.00002C20 12.253 17.384 15.55 12 18.834C6.617 15.549 4 12.254 4 9.00002C4 4.54102 9.323 3.51002 11.089 7.41202C11.444 8.19602 12.556 8.19602 12.911 7.41202Z"
            fill={props.fill}
        />
    </svg>
);

HeartOutlineIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default HeartOutlineIcon;
