import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HotelIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M4.00008 9.23198C3.47053 9.5043 3.01191 9.90225 2.66654 10.3947C2.20436 11.0536 1.97032 11.8457 2.00008 12.65V22H5.00008L6.00008 20H18.0001L19.0001 22H22.0001V12.65C22.0299 11.8457 21.7958 11.0536 21.3336 10.3947C20.9883 9.90225 20.5296 9.5043 20.0001 9.23198V6.5C20.0001 5.10218 20.0001 4.40326 19.7717 3.85195C19.4672 3.11687 18.8832 2.53284 18.1481 2.22836C17.5968 2 16.8979 2 15.5001 2H8.50008C7.10226 2 6.40335 2 5.85203 2.22836C5.11695 2.53284 4.53293 3.11687 4.22845 3.85195C4.00008 4.40326 4.00008 5.10217 4.00008 6.5V9.23198ZM16.5001 8.3357C13.5211 7.83464 10.479 7.83464 7.50008 8.3357V5.76C7.49813 5.66512 7.51578 5.57086 7.55191 5.48311C7.58804 5.39535 7.64189 5.316 7.71008 5.25C7.84572 5.1229 8.02421 5.0515 8.21008 5.05H8.36008C9.55768 5.30762 10.7758 5.45821 12.0001 5.5C13.2241 5.4615 14.4422 5.31425 15.6401 5.06H15.7901C15.976 5.0615 16.1545 5.1329 16.2901 5.26C16.3583 5.326 16.4121 5.40535 16.4483 5.4931C16.4844 5.58086 16.502 5.67512 16.5001 5.77V8.3357ZM4.00008 12.65V14H20.0001V12.65C20.0095 12.2924 19.9064 11.9408 19.7055 11.6448C19.5046 11.3488 19.2159 11.1233 18.8801 11C14.3827 9.71982 9.61742 9.71982 5.12008 11C4.78426 11.1233 4.49557 11.3488 4.29466 11.6448C4.09374 11.9408 3.99071 12.2924 4.00008 12.65Z"
            fill={props.fill}
        />
    </svg>
);

HotelIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default HotelIcon;
