import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HygieneKitIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#d12986fb__clip0_20315_4893)">
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M7.67999 3.10501H11.145C11.4744 3.10887 11.7916 3.23045 12.0392 3.44778C12.2868 3.66512 12.4485 3.96383 12.495 4.28998L14.325 23.97H4.5L6.33005 4.33502C6.36011 3.99817 6.51548 3.6848 6.76547 3.45703C7.01546 3.22926 7.3418 3.10367 7.67999 3.10501ZM8.40009 7.49998H10.41C10.6046 7.49908 10.7924 7.57088 10.9367 7.70131C11.081 7.83173 11.1714 8.01133 11.1901 8.20494L12.1351 18.285C12.1496 18.4479 12.1301 18.6121 12.078 18.7672C12.026 18.9223 11.9424 19.065 11.8325 19.1861C11.7226 19.3073 11.5887 19.4044 11.4395 19.4713C11.2902 19.5383 11.1286 19.5735 10.965 19.575H7.86002C7.69574 19.5758 7.53314 19.5421 7.38276 19.4759C7.23238 19.4098 7.09762 19.3127 6.98725 19.191C6.87688 19.0693 6.79337 18.9258 6.74217 18.7697C6.69096 18.6136 6.67322 18.4484 6.69007 18.285L7.62007 8.20494C7.64196 8.01261 7.73327 7.83495 7.87687 7.70515C8.02047 7.57536 8.20654 7.50239 8.40009 7.49998Z"
                fill={props.fill}
            />
            <path
                d="M11.7751 2.03998H7.05007C6.78497 2.03998 6.57007 1.82508 6.57007 1.55998V0.479978C6.57007 0.214881 6.78497 -2.14577e-05 7.05007 -2.14577e-05H11.7751C12.0402 -2.14577e-05 12.2551 0.214881 12.2551 0.479978V1.55998C12.2551 1.82508 12.0402 2.03998 11.7751 2.03998Z"
                fill={props.fill}
            />
            <path
                d="M18.3301 24C18.1818 24.002 18.0346 23.9742 17.8972 23.9184C17.7598 23.8626 17.635 23.7799 17.5301 23.675C17.4253 23.5701 17.3424 23.4453 17.2866 23.3079C17.2308 23.1705 17.2031 23.0233 17.2051 22.875V11.745C17.1979 11.6602 17.1979 11.5748 17.2051 11.49L18.7951 7.28998V1.125C18.7951 0.826631 18.9137 0.540477 19.1246 0.329498C19.3356 0.11852 19.6218 0 19.9201 0C20.2185 0 20.5047 0.11852 20.7156 0.329498C20.9266 0.540477 21.0451 0.826631 21.0451 1.125V7.41C21.0524 7.48984 21.0524 7.57013 21.0451 7.64996L19.4701 11.865V22.875C19.4701 23.024 19.4406 23.1715 19.3831 23.309C19.3256 23.4464 19.2414 23.5711 19.1353 23.6758C19.0293 23.7805 18.9034 23.8631 18.7652 23.9187C18.627 23.9743 18.4791 24.002 18.3301 24Z"
                fill={props.fill}
            />
            <path
                d="M18.075 7.16998H16.0801C16.0801 6.38998 16.3651 6.08998 16.3651 5.66998C16.3651 5.24998 16.0801 4.17002 16.0801 3.73502C16.0801 3.30002 16.3651 2.59507 16.3651 2.10007C16.2326 1.49144 16.1374 0.875233 16.0801 0.255005H18.075V7.16998Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="d12986fb__clip0_20315_4893">
                <rect width={24} height={24} fill="white" />
            </clipPath>
        </defs>
    </svg>
);

HygieneKitIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default HygieneKitIcon;
