import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const IncludedIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M19.1879 6.80001C19.6466 6.28404 20.4344 6.22887 20.9504 6.68751C21.4664 7.14616 21.5216 7.93404 21.0629 8.45001L12.1431 17.0023C12.0804 17.0705 12.0804 17.0705 12.0134 17.1344C11.2524 17.8368 10.0662 17.7892 9.36387 17.0283L5.44981 12.85C4.98159 12.3427 5.01709 11.5432 5.5244 11.075C6.0317 10.6068 6.81928 10.6427 7.2875 11.15L10.733 14.8256L19.1879 6.80001Z"
            fill={props.fill}
        />
    </svg>
);

IncludedIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default IncludedIcon;
