import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const Luggage30Icon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <mask
            id="65708396__mask0_14213_169"
            style={{
                maskType: 'alpha',
            }}
            maskUnits="userSpaceOnUse"
            x={6}
            y={21}
            width={12}
            height={2}
        >
            <rect x={6} y={21} width={12} height={2} fill="#C4C4C4" />
        </mask>
        <g mask="url(#65708396__mask0_14213_169)">
            <circle cx={8.5} cy={21.5} r={1.5} fill={props.fill} />
            <circle cx={15.5} cy={21.5} r={1.5} fill={props.fill} />
        </g>
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M7.61935 5H16.3806C17.8032 5 19 6.15556 19 7.57778V17.2779C19 18.2203 18.2144 19.3101 17.3461 19.8271C17.1262 19.958 16.8685 20.0001 16.6125 20.0001H16.5H15.5L14 20.0001H13.5H11H10H8.5H7.39583C7.13448 20.0001 6.87124 19.956 6.64812 19.8199C5.79582 19.3 5 18.2159 5 17.2779V7.57778C5 6.15556 6.19677 5 7.61935 5ZM9.13226 1C8.77097 1 8.47742 1.28889 8.47742 1.64444V4H9.5V3.96117V3.00006V2.00006H14.5V4H15.5452V1.64444C15.5452 1.28889 15.2516 1 14.8903 1H9.13226ZM11.14 14.498C11.254 14.258 11.311 13.988 11.311 13.688C11.311 13.466 11.269 13.265 11.185 13.085C11.107 12.905 10.999 12.752 10.861 12.626C10.729 12.494 10.573 12.389 10.393 12.311C10.219 12.227 10.036 12.173 9.844 12.149C10.006 12.119 10.162 12.068 10.312 11.996C10.462 11.918 10.594 11.819 10.708 11.699C10.822 11.573 10.912 11.429 10.978 11.267C11.05 11.105 11.086 10.919 11.086 10.709C11.086 10.457 11.035 10.226 10.933 10.016C10.837 9.80602 10.696 9.62602 10.51 9.47602C10.33 9.32602 10.108 9.20902 9.844 9.12502C9.586 9.04102 9.295 8.99902 8.971 8.99902C8.539 8.99902 8.173 9.05002 7.873 9.15202C7.573 9.25402 7.318 9.38902 7.108 9.55702V10.556C7.33 10.37 7.579 10.214 7.855 10.088C8.131 9.95602 8.464 9.89002 8.854 9.89002C9.232 9.89002 9.52 9.97102 9.718 10.133C9.916 10.289 10.015 10.505 10.015 10.781C10.015 11.087 9.913 11.324 9.709 11.492C9.505 11.654 9.238 11.735 8.908 11.735H8.062V12.644H8.872C9.76 12.644 10.204 12.986 10.204 13.67C10.204 14.006 10.087 14.27 9.853 14.462C9.619 14.654 9.286 14.75 8.854 14.75C8.422 14.75 8.056 14.684 7.756 14.552C7.456 14.414 7.204 14.261 7 14.093V15.101C7.198 15.251 7.453 15.377 7.765 15.479C8.083 15.581 8.467 15.632 8.917 15.632C9.277 15.632 9.604 15.587 9.898 15.497C10.192 15.407 10.444 15.278 10.654 15.11C10.864 14.936 11.026 14.732 11.14 14.498ZM13.31 15.4258C13.634 15.5638 13.982 15.6328 14.354 15.6328C14.726 15.6328 15.071 15.5608 15.389 15.4168C15.713 15.2728 15.995 15.0598 16.235 14.7778C16.475 14.4958 16.661 14.1478 16.793 13.7338C16.931 13.3198 17 12.8398 17 12.2938C17 11.7478 16.931 11.2708 16.793 10.8628C16.661 10.4488 16.475 10.1068 16.235 9.83682C15.995 9.56082 15.713 9.35382 15.389 9.21582C15.071 9.07782 14.726 9.00882 14.354 9.00882C13.982 9.00882 13.634 9.07782 13.31 9.21582C12.986 9.35382 12.704 9.56082 12.464 9.83682C12.224 10.1128 12.035 10.4578 11.897 10.8718C11.759 11.2858 11.69 11.7658 11.69 12.3118C11.69 12.8638 11.759 13.3468 11.897 13.7608C12.035 14.1748 12.224 14.5198 12.464 14.7958C12.704 15.0718 12.986 15.2818 13.31 15.4258ZM14.966 14.6338C14.774 14.7178 14.567 14.7598 14.345 14.7598C14.129 14.7598 13.925 14.7178 13.733 14.6338C13.541 14.5438 13.373 14.4028 13.229 14.2108C13.091 14.0188 12.98 13.7698 12.896 13.4638C12.818 13.1518 12.779 12.7708 12.779 12.3208C12.779 11.8708 12.818 11.4928 12.896 11.1868C12.98 10.8748 13.091 10.6228 13.229 10.4308C13.373 10.2328 13.541 10.0918 13.733 10.0078C13.925 9.91782 14.132 9.87282 14.354 9.87282C14.57 9.87282 14.774 9.91782 14.966 10.0078C15.158 10.0918 15.323 10.2328 15.461 10.4308C15.605 10.6228 15.716 10.8748 15.794 11.1868C15.878 11.4928 15.92 11.8708 15.92 12.3208C15.92 12.7708 15.878 13.1518 15.794 13.4638C15.716 13.7698 15.605 14.0188 15.461 14.2108C15.323 14.4028 15.158 14.5438 14.966 14.6338Z"
            fill={props.fill}
        />
    </svg>
);

Luggage30Icon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default Luggage30Icon;
