import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const LuggageDoubleIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <mask
            id="f7d034c1__mask0_14213_172"
            style={{
                maskType: 'alpha',
            }}
            maskUnits="userSpaceOnUse"
            x={6}
            y={21}
            width={12}
            height={2}
        >
            <rect x={6} y={21} width={12} height={2} fill="#C4C4C4" />
        </mask>
        <g mask="url(#f7d034c1__mask0_14213_172)">
            <circle cx={8.5} cy={21.5} r={1.5} fill={props.fill} />
            <circle cx={15.5} cy={21.5} r={1.5} fill={props.fill} />
        </g>
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M7.61935 5H16.3806C17.8032 5 19 6.15556 19 7.57778V17.2779C19 18.2203 18.2144 19.3101 17.3461 19.8271C17.1262 19.958 16.8685 20.0001 16.6125 20.0001H16.5H15.5L14 20.0001H13.5H11H10H8.5H7.39583C7.13448 20.0001 6.87124 19.956 6.64812 19.8199C5.79582 19.3 5 18.2159 5 17.2779V7.57778C5 6.15556 6.19677 5 7.61935 5ZM9.13226 1C8.77097 1 8.47742 1.28889 8.47742 1.64444V4H9.5V3.96117V3.00006V2.00006H14.5V4H15.5452V1.64444C15.5452 1.28889 15.2516 1 14.8903 1H9.13226ZM12.261 15.4999H16.482V14.4649H13.593C14.091 14.0989 14.523 13.7659 14.889 13.4659C15.255 13.1599 15.555 12.8689 15.789 12.5929C16.029 12.3169 16.206 12.0439 16.32 11.7739C16.44 11.5039 16.5 11.2189 16.5 10.9189C16.5 10.6129 16.449 10.3399 16.347 10.0999C16.245 9.85392 16.098 9.64692 15.906 9.47892C15.72 9.31092 15.495 9.18492 15.231 9.10092C14.967 9.01092 14.676 8.96592 14.358 8.96592C13.926 8.96592 13.56 9.02592 13.26 9.14592C12.966 9.25992 12.693 9.41292 12.441 9.60492V10.7389C12.699 10.5109 12.972 10.3279 13.26 10.1899C13.554 10.0519 13.86 9.98292 14.178 9.98292C14.496 9.98292 14.742 10.0699 14.916 10.2439C15.096 10.4119 15.186 10.6459 15.186 10.9459C15.186 11.1919 15.135 11.4289 15.033 11.6569C14.931 11.8849 14.766 12.1279 14.538 12.3859C14.31 12.6439 14.007 12.9289 13.629 13.2409C13.257 13.5529 12.801 13.9099 12.261 14.3119V15.4999ZM8.28937 15.4999L9.32437 13.8979L10.3864 15.4999H11.7814L10.1974 13.1059L11.6824 10.8289H10.4944L9.59437 12.2779L8.63137 10.8289H7.23637L8.71237 13.0699L7.10137 15.4999H8.28937Z"
            fill={props.fill}
        />
    </svg>
);

LuggageDoubleIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default LuggageDoubleIcon;
