import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const LuggageX1Icon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <mask
            id="9fb7afb7__mask0_14213_171"
            style={{
                maskType: 'alpha',
            }}
            maskUnits="userSpaceOnUse"
            x={6}
            y={21}
            width={12}
            height={2}
        >
            <rect x={6} y={21} width={12} height={2} fill="#C4C4C4" />
        </mask>
        <g mask="url(#9fb7afb7__mask0_14213_171)">
            <circle cx={8.5} cy={21.5} r={1.5} fill={props.fill} />
            <circle cx={15.5} cy={21.5} r={1.5} fill={props.fill} />
        </g>
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M7.61935 5H16.3806C17.8032 5 19 6.15556 19 7.57778V17.2779C19 18.2203 18.2144 19.3101 17.3461 19.8271C17.1262 19.958 16.8685 20.0001 16.6125 20.0001H16.5H15.5L14 20.0001H13.5H11H10H8.5H7.39583C7.13448 20.0001 6.87124 19.956 6.64812 19.8199C5.79582 19.3 5 18.2159 5 17.2779V7.57778C5 6.15556 6.19677 5 7.61935 5ZM9.13226 1C8.77097 1 8.47742 1.28889 8.47742 1.64444V4H9.5V3.96117V3.00006V2.00006H14.5V4H15.5452V1.64444C15.5452 1.28889 15.2516 1 14.8903 1H9.13226ZM14.7489 15.453H15.9999V9H14.8929L13.4169 10.476V11.691L14.7489 10.368V15.453ZM9.08093 15.453L10.1159 13.851L11.1779 15.453H12.5729L10.9889 13.059L12.4739 10.782H11.2859L10.3859 12.231L9.42293 10.782H8.02793L9.50393 13.023L7.89293 15.453H9.08093Z"
            fill={props.fill}
        />
    </svg>
);

LuggageX1Icon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default LuggageX1Icon;
