import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const MessageOutlineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6.1491 5.10166C4.8929 5.8747 4 7.25186 4 10C4 14.3723 6.3839 15.8152 7.24254 16.0299C7.6877 16.1411 8 16.5411 8 17V19.0793L11.4265 16.6808C11.5946 16.5631 11.7948 16.5 12 16.5C14.7062 16.5 16.6836 16.1206 17.9782 15.1885C19.195 14.3123 20 12.7992 20 10C20 7.25186 19.1071 5.8747 17.8509 5.10166C16.4832 4.26001 14.4846 4 12 4C9.51544 4 7.51677 4.26001 6.1491 5.10166ZM5.1009 3.39834C6.98323 2.23999 9.48456 2 12 2C14.5154 2 17.0168 2.23999 18.8991 3.39834C20.8929 4.6253 22 6.74814 22 10C22 13.2008 21.055 15.4377 19.1468 16.8115C17.386 18.0793 14.9847 18.4704 12.3176 18.4984L7.57346 21.8192C7.26799 22.0331 6.86892 22.0592 6.53819 21.887C6.20746 21.7148 6 21.3729 6 21V17.6966C4.22953 16.87 2 14.5452 2 10C2 6.74814 3.1071 4.6253 5.1009 3.39834Z"
            fill={props.fill}
        />
    </svg>
);

MessageOutlineIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default MessageOutlineIcon;
