import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const MiniBarIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M10.75 0H13.25C13.6642 0 14 0.335786 14 0.75V1C14 1.27614 13.7761 1.5 13.5 1.5H10.5C10.2239 1.5 10 1.27614 10 1V0.75C10 0.335786 10.3358 0 10.75 0Z"
            fill={props.fill}
        />
        <path
            d="M7.95 8.4L8.19452 8.07397C8.34432 7.87424 8.41108 7.78178 8.4537 7.71502C8.4256 7.61459 8.397 7.48502 8.34259 7.21296L7.77746 4.38732C7.94211 4.25288 8.0084 4.02237 7.92537 3.81452L7.65026 3.12581C7.62446 3.06122 7.56743 3.01553 7.50066 3.00328L7.5 3C7.77614 3 8 2.77614 8 2.5V2.25C8 1.83579 7.66421 1.5 7.25 1.5H4.75C4.33579 1.5 4 1.83579 4 2.25V2.5C4 2.77614 4.22386 3 4.5 3L4.49935 3.00326C4.43258 3.01546 4.37553 3.06109 4.34968 3.12564L4.07393 3.81409C4.05025 3.87321 4.03808 3.93631 4.03808 4C4.03808 4.15645 4.10993 4.29612 4.22244 4.3878L3.65741 7.21296C3.58583 7.57085 3.55892 7.68217 3.51907 7.80494C3.47922 7.92771 3.43227 8.03272 3.36735 8.14428C3.30243 8.25584 3.23741 8.35012 3.01842 8.6421L2.75 9C2.26317 9.64911 2 10.4386 2 11.25V20.9833C2 21.3177 2.16715 21.63 2.44541 21.8155C3.63027 22.6052 4.81514 23 6 23C6.35726 23 6.71453 22.9641 7.07179 22.8923C7.0248 22.7218 7 22.5434 7 22.3609V11.25C7 10.2222 7.33334 9.22221 7.95 8.4Z"
            fill={props.fill}
        />
        <path
            d="M17 22.3609C17 22.5434 16.9752 22.7218 16.9282 22.8923C17.2855 22.9641 17.6427 23 18 23C19.1849 23 20.3697 22.6052 21.5546 21.8155C21.8328 21.63 22 21.3178 22 20.9834L22 11.25C22 10.4386 21.7368 9.64911 21.25 9L20.9816 8.6421C20.7626 8.35012 20.6976 8.25584 20.6327 8.14428C20.5677 8.03272 20.5208 7.92771 20.4809 7.80494C20.4411 7.68217 20.4142 7.57085 20.3426 7.21296L19.7775 4.38732C19.9421 4.25288 20.0084 4.02237 19.9254 3.81452L19.6503 3.12581C19.6245 3.06122 19.5674 3.01553 19.5007 3.00328L19.5 3C19.7761 3 20 2.77614 20 2.5V2.25C20 1.83579 19.6642 1.5 19.25 1.5H16.75C16.3358 1.5 16 1.83579 16 2.25V2.5C16 2.77614 16.2239 3 16.5 3L16.4993 3.00326C16.4326 3.01546 16.3755 3.06109 16.3497 3.12564L16.0739 3.81409C16.0502 3.87321 16.0381 3.93631 16.0381 4C16.0381 4.15645 16.1099 4.29612 16.2224 4.3878L15.6574 7.21296C15.603 7.48502 15.5744 7.61459 15.5463 7.71502C15.5889 7.78178 15.6557 7.87424 15.8055 8.07397L16.05 8.4C16.6667 9.22221 17 10.2222 17 11.25L17 22.3609Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M10.0385 3C10.0385 3.17463 10.128 3.32835 10.2637 3.41777L9.6385 7.16899C9.57616 7.54305 9.55093 7.66103 9.51175 7.79144C9.47257 7.92184 9.42452 8.03413 9.35725 8.15251C9.28997 8.27089 9.22205 8.3706 8.99452 8.67397L8.75 9C8.26317 9.64911 8 10.4386 8 11.25V22.3609C8 22.7624 8.24013 23.125 8.60979 23.2816C9.73985 23.7605 10.8699 24 12 24C13.1301 24 14.2601 23.7606 15.3902 23.2817C15.7599 23.125 16 22.7624 16 22.3609L16 11.25C16 10.4386 15.7368 9.64911 15.25 9L15.0055 8.67397C14.778 8.3706 14.71 8.27089 14.6428 8.15251C14.5755 8.03413 14.5274 7.92184 14.4882 7.79144C14.4491 7.66103 14.4238 7.54305 14.3615 7.16899L13.7363 3.41782C13.931 3.29005 14.0156 3.0389 13.9257 2.8143L13.6503 2.12572C13.6244 2.06112 13.5674 2.01544 13.5005 2.00325L13.5 2H10.5L10.4995 2.00325C10.4326 2.01544 10.3756 2.06112 10.3497 2.12572L10.0743 2.8143C10.0507 2.87336 10.0385 2.93639 10.0385 3ZM11.75 5C11.6553 5 11.5673 5.03846 11.5036 5.10275L11.1181 7.41559C11.0482 7.8352 11.0122 8.0105 10.9483 8.22307C10.8767 8.46127 10.7843 8.67737 10.6614 8.89362C10.5517 9.08659 10.4498 9.23366 10.1945 9.57397L9.95 9.9C9.6579 10.2895 9.5 10.7632 9.5 11.25V22.023C9.83519 22.15 10.1684 22.2514 10.5 22.3274V18.8368C10.9495 18.9456 11.4495 19 12 19C12.8538 19 13.5861 18.8692 14.1969 18.6075C14.3807 18.5287 14.4999 18.348 14.4999 18.148L14.5 13.7524C14.4999 13.7002 14.4916 13.6483 14.4755 13.5986C14.3901 13.336 14.108 13.1924 13.8454 13.2778C13.3109 13.4516 12.6958 13.5385 12 13.5385C11.4495 13.5385 10.9495 13.4802 10.5 13.3636V11.75C10.5 10.9386 10.7632 10.1491 11.25 9.5C11.7368 8.85089 12 8.06139 12 7.25V5.25C12 5.11193 11.8881 5 11.75 5Z"
            fill={props.fill}
        />
    </svg>
);

MiniBarIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default MiniBarIcon;
