import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const MinusIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M4 11H13H20C20.5523 11 21 11.4477 21 12C21 12.5523 20.5523 13 20 13H13H4C3.44772 13 3 12.5523 3 12C3 11.4477 3.44772 11 4 11Z"
            fill={props.fill}
        />
    </svg>
);

MinusIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default MinusIcon;
