import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const NoTicketReturnIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#e98210e1__clip0_19073_4587)">
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M10.1458 18.7489C10.747 18.9145 11.3705 18.9997 12 19C13.8565 19 15.637 18.2625 16.9497 16.9497C18.2625 15.637 19 13.8565 19 12C19 10.9488 18.7636 9.92207 18.3202 8.99077L16.8425 10.7548C16.9462 11.1582 17 11.5763 17 12C17 13.3261 16.4732 14.5979 15.5355 15.5355C14.5979 16.4732 13.3261 17 12 17C11.873 17 11.7472 16.9952 11.6227 16.9858L10.1458 18.7489ZM15.7667 8.71185L17.0622 7.16534C17.0252 7.12659 16.9877 7.08823 16.9497 7.05025C15.637 5.7375 13.8565 5 12 5C10.2114 4.99877 8.49104 5.68634 7.196 6.92L5.099 5L3.998 12.127L11 10.402L8.684 8.282C9.59193 7.45795 10.7739 7.001 12 7C13.3261 7 14.5979 7.52679 15.5355 8.46447C15.6156 8.54455 15.6927 8.62707 15.7667 8.71185ZM9.42819 16.2785L8.12912 17.8293C7.11293 17.1533 6.29007 16.2224 5.744 15.128L7.545 14.227C7.97044 15.0748 8.62465 15.7878 9.42819 16.2785Z"
                fill={props.fill}
            />
            <path
                d="M4.49599 19.9307C4.49369 19.6611 4.59569 19.3831 4.78005 19.1564L17.9365 3.45084C18.1274 3.22962 18.383 3.08073 18.6484 3.03622C18.9137 2.99171 19.1676 3.05516 19.3552 3.21289C19.5428 3.37062 19.6493 3.61002 19.6516 3.87953C19.6539 4.14903 19.5519 4.42708 19.3675 4.65378L6.21106 20.3593C6.02019 20.5806 5.76455 20.7295 5.4992 20.774C5.23384 20.8185 4.98001 20.755 4.79237 20.5973C4.60473 20.4396 4.4983 20.2002 4.49599 19.9307Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="e98210e1__clip0_19073_4587">
                <rect
                    width={16}
                    height={18}
                    fill="white"
                    transform="translate(4 3)"
                />
            </clipPath>
        </defs>
    </svg>
);

NoTicketReturnIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default NoTicketReturnIcon;
