import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const OrdersIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M9 5C9 3.34315 10.3431 2 12 2C13.6569 2 15 3.34315 15 5V7H9V5Z"
            stroke={props.fill}
            strokeWidth={2}
        />
        <path
            d="M3 10C3 8.34315 4.34315 7 6 7H18C19.6569 7 21 8.34315 21 10V17C21 18.6569 19.6569 20 18 20H6C4.34315 20 3 18.6569 3 17V10Z"
            stroke={props.fill}
            strokeWidth={2}
        />
        <rect x={8} y={6} width={2} height={5} rx={1} fill={props.fill} />
        <rect x={14} y={6} width={2} height={5} rx={1} fill={props.fill} />
    </svg>
);

OrdersIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default OrdersIcon;
