import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const PaidReturnIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M9.48675 11.8382V6H12.5509C13.9047 6 14.9563 6.29614 15.7057 6.88842C16.4672 7.48071 16.848 8.37517 16.848 9.57183C16.848 10.1883 16.7392 10.7201 16.5216 11.1674C16.3161 11.6146 16.0139 11.9833 15.6151 12.2734C15.2283 12.5514 14.7629 12.7629 14.219 12.9079C13.675 13.0409 13.0707 13.1074 12.4059 13.1074H11.1911V14.6485H14.9805V15.9177H11.1911V19H9.48675V15.9177H8V14.6485H9.48675V13.1074H8V11.8382H9.48675ZM11.1911 7.46862V11.8382H12.4059C13.2882 11.8382 13.9591 11.6569 14.4184 11.2943C14.8898 10.9196 15.1255 10.3454 15.1255 9.57183C15.1255 8.85867 14.92 8.33287 14.5091 7.99442C14.1102 7.64389 13.4575 7.46862 12.5509 7.46862H11.1911Z"
            fill={props.fill}
        />
    </svg>
);

PaidReturnIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default PaidReturnIcon;
