import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const PatioIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M19.5393 10.2857C18.617 10.2857 17.8082 9.80023 17.3544 9.07089C17.2209 8.85638 16.9388 8.79069 16.7243 8.92416C16.66 8.96421 16.6066 9.01962 16.5689 9.08542C16.5492 9.11985 16.5291 9.15188 16.5084 9.18149C16.0439 9.8489 15.2712 10.2857 14.3964 10.2857C13.5227 10.2857 12.7507 9.84993 12.286 9.18386C12.1082 8.92896 11.7574 8.86649 11.5025 9.04432C11.4452 9.08431 11.3958 9.13464 11.3569 9.19272C11.3471 9.20746 11.3371 9.22165 11.3271 9.23533C10.8591 9.87229 10.1046 10.2857 9.25355 10.2857C8.43204 10.2857 7.70051 9.90047 7.22975 9.3008C7.22575 9.29571 7.22177 9.29055 7.21781 9.28532C6.99364 8.98948 6.57209 8.93142 6.27627 9.15562C6.22866 9.19171 6.18608 9.23398 6.14964 9.28132C5.67951 9.89212 4.94107 10.2857 4.1107 10.2857C2.69054 10.2857 1.53927 9.13444 1.53927 7.71428C1.53927 7.22817 8.92503 4.8308 9.98228 0.522186C10.0575 0.21557 10.3325 0 10.6482 0L13.0019 0.000106274C13.3176 0.000106274 13.5925 0.215697 13.6677 0.522308C14.7249 4.83027 22.1107 7.2276 22.1107 7.71428C22.1107 9.13444 20.9594 10.2857 19.5393 10.2857Z"
            fill={props.fill}
        />
        <path
            d="M10.9678 9.42858C10.9678 8.95519 11.3516 8.57144 11.825 8.57144C12.2984 8.57144 12.6821 8.95519 12.6821 9.42858V23.1429C12.6821 23.6162 12.2984 24 11.825 24C11.3516 24 10.9678 23.6162 10.9678 23.1429V9.42858Z"
            fill={props.fill}
        />
        <path
            d="M5.82498 14.625C5.82498 14.0037 6.32865 13.5 6.94997 13.5H16.7C17.3213 13.5 17.825 14.0037 17.825 14.625C17.825 15.2463 17.3213 15.75 16.7 15.75H6.94997C6.32865 15.75 5.82498 15.2463 5.82498 14.625Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M0.574978 12.75C0.574978 12.3358 0.910764 12 1.32498 12C1.73919 12 2.07498 12.3358 2.07498 12.75V17.25C2.07498 17.6642 2.41076 18 2.82498 18H5.82498C5.83859 18 5.8522 18 5.86578 18C6.18383 17.9999 6.49293 17.9999 6.74786 18.0341C7.03527 18.0728 7.36322 18.1669 7.63563 18.4393C7.90805 18.7117 8.00219 19.0397 8.04083 19.3271C8.0751 19.582 8.07504 19.8911 8.07498 20.2092C8.07498 20.2228 8.07497 20.2364 8.07497 20.25V23.0024C8.07497 23.4166 7.73919 23.7524 7.32497 23.7524C6.91076 23.7524 6.57498 23.4166 6.57498 23.0024V20.25C6.57498 19.8752 6.57338 19.6696 6.5542 19.527C6.55376 19.5237 6.55122 19.5212 6.54799 19.5208C6.40535 19.5016 3.19973 19.5 2.82498 19.5C2.41076 19.5 2.07498 19.8358 2.07498 20.25V23.0024C2.07498 23.4166 1.73919 23.7524 1.32498 23.7524C0.910764 23.7524 0.574978 23.4166 0.574978 23.0024V12.75Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M0.349976 12.75C0.349976 12.2115 0.786498 11.775 1.32498 11.775C1.86345 11.775 2.29997 12.2115 2.29997 12.75V17.25C2.29997 17.5399 2.53503 17.775 2.82497 17.775L5.8763 17.7749C6.18642 17.7749 6.50789 17.7748 6.77784 17.8111C7.08997 17.8531 7.47344 17.9589 7.79473 18.2802C8.11602 18.6015 8.22185 18.985 8.26382 19.2971C8.30011 19.567 8.30005 19.8885 8.29998 20.1986L8.29997 23.0023C8.29997 23.5408 7.86345 23.9773 7.32497 23.9773C6.7865 23.9773 6.34997 23.5408 6.34997 23.0023V20.25C6.34997 20.0174 6.3492 19.8569 6.34482 19.739C6.24525 19.7373 6.11268 19.7357 5.95683 19.7344C5.63102 19.7315 5.20572 19.7295 4.7728 19.7281C3.90706 19.7254 3.01223 19.725 2.82497 19.725C2.53503 19.725 2.29997 19.96 2.29997 20.25V23.0023C2.29997 23.5408 1.86345 23.9773 1.32498 23.9773C0.786498 23.9773 0.349976 23.5408 0.349976 23.0023V12.75ZM6.7772 19.497C6.79887 19.6582 6.79997 19.8821 6.79997 20.25V23.0023C6.79997 23.2923 7.03502 23.5273 7.32497 23.5273C7.61492 23.5273 7.84997 23.2923 7.84997 23.0023L7.84998 20.2091C7.85004 19.8864 7.84968 19.5939 7.81783 19.357C7.78252 19.0944 7.70007 18.8219 7.47653 18.5984C7.253 18.3749 6.98055 18.2924 6.71788 18.2571C6.48102 18.2253 6.18855 18.2249 5.86583 18.225L2.82497 18.225C2.2865 18.225 1.84997 17.7884 1.84997 17.25V12.75C1.84997 12.46 1.61492 12.225 1.32498 12.225C1.03503 12.225 0.799975 12.46 0.799975 12.75V23.0023C0.799975 23.2923 1.03503 23.5273 1.32498 23.5273C1.61492 23.5273 1.84997 23.2923 1.84997 23.0023V20.25C1.84997 19.7115 2.2865 19.275 2.82497 19.275C3.01248 19.275 3.90784 19.2754 4.77425 19.2782C5.2074 19.2795 5.63368 19.2815 5.96075 19.2844C6.1242 19.2858 6.26344 19.2875 6.36658 19.2894C6.45998 19.2911 6.54361 19.2931 6.57797 19.2977C6.68118 19.3119 6.76304 19.3937 6.7772 19.497Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M23.075 12.75C23.075 12.3358 22.7392 12 22.325 12C21.9108 12 21.575 12.3358 21.575 12.75V17.2462C21.575 17.6604 21.2392 17.9962 20.825 17.9962H17.825C17.8114 17.9962 17.7978 17.9962 17.7842 17.9962C17.4661 17.9962 17.157 17.9961 16.9021 18.0303C16.6147 18.069 16.2867 18.163 16.0143 18.4353C15.7419 18.7075 15.6478 19.0353 15.6091 19.3225C15.5749 19.5773 15.5749 19.8862 15.575 20.204C15.575 20.2176 15.575 20.2312 15.575 20.2448V22.995C15.575 23.4092 15.9108 23.745 16.325 23.745C16.7392 23.745 17.075 23.4092 17.075 22.995V20.2448C17.075 19.8703 17.0766 19.6648 17.0957 19.5222C17.0962 19.519 17.0987 19.5165 17.102 19.516C17.2446 19.4969 20.4502 19.4953 20.825 19.4953C21.2392 19.4953 21.575 19.8311 21.575 20.2453V22.995C21.575 23.4092 21.9108 23.745 22.325 23.745C22.7392 23.745 23.075 23.4092 23.075 22.995V12.75Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M23.3 12.75C23.3 12.2115 22.8634 11.775 22.325 11.775C21.7865 11.775 21.35 12.2115 21.35 12.75V17.2462C21.35 17.5361 21.1149 17.7712 20.825 17.7712L17.7737 17.7712C17.4635 17.7711 17.1421 17.771 16.8721 17.8073C16.56 17.8492 16.1766 17.955 15.8553 18.2761C15.534 18.5972 15.4281 18.9805 15.3861 19.2925C15.3498 19.5623 15.3499 19.8836 15.35 20.1935L15.35 22.995C15.35 23.5334 15.7865 23.97 16.325 23.97C16.8635 23.97 17.3 23.5334 17.3 22.995V20.2448C17.3 20.0124 17.3008 19.8521 17.3051 19.7343C17.4047 19.7326 17.5373 19.731 17.6931 19.7297C18.0189 19.7268 18.4442 19.7248 18.8772 19.7234C19.7429 19.7206 20.6377 19.7202 20.825 19.7202C21.1149 19.7202 21.35 19.9553 21.35 20.2452V22.995C21.35 23.5334 21.7865 23.97 22.325 23.97C22.8634 23.97 23.3 23.5334 23.3 22.995V12.75ZM16.8728 19.4922C16.8511 19.6534 16.85 19.8772 16.85 20.2448V22.995C16.85 23.2849 16.6149 23.52 16.325 23.52C16.035 23.52 15.8 23.2849 15.8 22.995L15.8 20.2039C15.7999 19.8814 15.8003 19.5891 15.8321 19.3525C15.8674 19.09 15.9499 18.8178 16.1734 18.5944C16.3969 18.371 16.6694 18.2886 16.9321 18.2533C17.1689 18.2215 17.4614 18.2211 17.7841 18.2212L20.825 18.2212C21.3635 18.2212 21.8 17.7847 21.8 17.2462V12.75C21.8 12.46 22.035 12.225 22.325 12.225C22.6149 12.225 22.85 12.46 22.85 12.75V22.995C22.85 23.2849 22.6149 23.52 22.325 23.52C22.035 23.52 21.8 23.2849 21.8 22.995V20.2452C21.8 19.7068 21.3634 19.2702 20.825 19.2702C20.6375 19.2702 19.7421 19.2706 18.8757 19.2734C18.4425 19.2748 18.0163 19.2768 17.6892 19.2797C17.5257 19.2811 17.3865 19.2827 17.2834 19.2846C17.19 19.2864 17.1063 19.2884 17.072 19.293C16.9689 19.3071 16.8869 19.3888 16.8728 19.4922Z"
            fill={props.fill}
        />
    </svg>
);

PatioIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default PatioIcon;
