import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const PlaneIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#9c8da995__clip0_27997_4807)">
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M7.24106 14.501C8.04109 13.5061 9.07178 12.2782 10.2929 10.9381L2.3034 5.61176C1.99038 5.40308 1.9058 4.98016 2.11448 4.66714L3.13299 3.13937C3.31167 2.87135 3.65367 2.76513 3.95275 2.88476L14.1892 6.97936C19.5032 2.00174 21.3315 1.67022 21.8306 2.16939C22.3306 2.66933 21.9973 4.50241 16.998 9.83501C15.0412 11.9223 11.7651 14.7384 9.49898 16.6242V21.0231C9.49898 21.2174 9.38921 21.395 9.21544 21.4819L8.28781 21.9457C8.03443 22.0724 7.72632 21.9697 7.59963 21.7163C7.59328 21.7036 7.58745 21.6907 7.58217 21.6775L6.07943 17.9206L2.32257 16.4179C2.05955 16.3126 1.93161 16.0141 2.03682 15.7511C2.0421 15.7379 2.04793 15.7249 2.05429 15.7122L2.5181 14.7846C2.60499 14.6108 2.7826 14.501 2.97688 14.501H7.24106ZM17.6338 11.3429L21.1156 20.0471C21.2352 20.3462 21.129 20.6882 20.861 20.8669L19.3332 21.8854C19.0202 22.0941 18.5972 22.0095 18.3886 21.6965L13.7969 14.809C14.8648 13.9881 15.9499 13.0497 16.9983 12.0013C17.2191 11.7804 17.4309 11.5608 17.6338 11.3429Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="9c8da995__clip0_27997_4807">
                <rect
                    width={20}
                    height={20}
                    fill="white"
                    transform="translate(2 2)"
                />
            </clipPath>
        </defs>
    </svg>
);

PlaneIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default PlaneIcon;
