import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const RefreshIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M12 2.18106C12.0001 2.04423 12.0376 1.91004 12.1085 1.79302C12.1794 1.67599 12.281 1.58059 12.4022 1.51715C12.5235 1.4537 12.6597 1.42463 12.7963 1.43307C12.9329 1.44152 13.0645 1.48716 13.177 1.56506L17.609 4.63306C17.7088 4.70205 17.7904 4.79424 17.8468 4.9017C17.9032 5.00917 17.9326 5.12871 17.9326 5.25006C17.9326 5.37141 17.9032 5.49095 17.8468 5.59842C17.7904 5.70588 17.7088 5.79807 17.609 5.86706L13.177 8.93506C13.0646 9.01291 12.933 9.05855 12.7965 9.06704C12.6601 9.07552 12.5239 9.04654 12.4027 8.98321C12.2815 8.91988 12.1799 8.82463 12.1089 8.70775C12.038 8.59086 12.0003 8.4568 12 8.32006V6.00006C10.6155 6.00006 9.26216 6.4106 8.11101 7.17977C6.95987 7.94894 6.06266 9.04219 5.53285 10.3213C5.00303 11.6004 4.86441 13.0078 5.13451 14.3657C5.4046 15.7236 6.07129 16.9708 7.05026 17.9498C8.02922 18.9288 9.27651 19.5955 10.6344 19.8656C11.9922 20.1357 13.3997 19.997 14.6788 19.4672C15.9579 18.9374 17.0511 18.0402 17.8203 16.8891C18.5895 15.7379 19 14.3845 19 13.0001C19 12.7348 19.1054 12.4805 19.2929 12.293C19.4804 12.1054 19.7348 12.0001 20 12.0001C20.2652 12.0001 20.5196 12.1054 20.7071 12.293C20.8946 12.4805 21 12.7348 21 13.0001C21 14.7801 20.4722 16.5202 19.4832 18.0002C18.4943 19.4802 17.0887 20.6338 15.4442 21.315C13.7996 21.9962 11.99 22.1744 10.2442 21.8271C8.49836 21.4799 6.89472 20.6227 5.63604 19.364C4.37737 18.1053 3.5202 16.5017 3.17294 14.7559C2.82567 13.01 3.0039 11.2004 3.68509 9.55591C4.36628 7.91138 5.51983 6.50577 6.99987 5.51683C8.47991 4.5279 10.22 4.00006 12 4.00006V2.18106Z"
            fill={props.fill}
        />
    </svg>
);

RefreshIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default RefreshIcon;
