import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SearchIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M9.49994 18C11.2099 18 12.7869 17.427 14.0499 16.463L18.7929 21.207C18.9815 21.3892 19.2341 21.49 19.4963 21.4877C19.7585 21.4854 20.0094 21.3802 20.1948 21.1948C20.3802 21.0094 20.4853 20.7586 20.4876 20.4964C20.4899 20.2342 20.3891 19.9816 20.2069 19.793L15.4629 15.049C16.4893 13.7036 17.0305 12.0507 16.9987 10.3589C16.9668 8.66704 16.3638 7.03568 15.2876 5.72988C14.2113 4.42409 12.7251 3.52062 11.0705 3.16628C9.41587 2.81195 7.69004 3.02757 6.17344 3.77811C4.65684 4.52865 3.43862 5.77 2.71673 7.30044C1.99485 8.83089 1.81172 10.5605 2.19711 12.2082C2.58251 13.8558 3.51377 15.3248 4.83957 16.3763C6.16537 17.4277 7.80779 18 9.49994 18ZM14.9999 10.5C14.9999 11.9587 14.4205 13.3576 13.389 14.3891C12.3576 15.4205 10.9586 16 9.49994 16C8.04125 16 6.64231 15.4205 5.61086 14.3891C4.57941 13.3576 3.99994 11.9587 3.99994 10.5C3.99994 9.04132 4.57941 7.64237 5.61086 6.61092C6.64231 5.57947 8.04125 5.00001 9.49994 5.00001C10.9586 5.00001 12.3576 5.57947 13.389 6.61092C14.4205 7.64237 14.9999 9.04132 14.9999 10.5Z"
            fill={props.fill}
        />
    </svg>
);

SearchIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default SearchIcon;
