import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SellIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M12 24C18.6274 24 24 18.6274 24 12C24 5.37258 18.6274 0 12 0C5.37258 0 0 5.37258 0 12C0 18.6274 5.37258 24 12 24ZM16.954 6.14706L5.69383 16.5679L7.5706 17.0747L18.8307 6.65386L16.954 6.14706ZM11.2643 10.5769C11.8779 10.146 12.3239 9.41499 12.6023 8.38392C12.887 7.32968 12.868 6.47933 12.5454 5.83287C12.2375 5.17795 11.6897 4.74412 10.9019 4.53138C10.1141 4.31865 9.41343 4.42775 8.79986 4.8587C8.18942 5.27806 7.74186 6.01485 7.45717 7.06909C7.17561 8.11174 7.19458 8.96209 7.51407 9.62014C7.83669 10.2666 8.39189 10.6962 9.17967 10.9089C9.96745 11.1217 10.6623 11.011 11.2643 10.5769ZM9.09425 8.94682C9.03877 8.64595 9.09863 8.17113 9.27382 7.52237C9.45214 6.86203 9.63364 6.42006 9.81832 6.19648C10.0146 5.97602 10.2459 5.90177 10.5124 5.97372C10.7788 6.04567 10.9356 6.22473 10.9826 6.51088C11.0412 6.80017 10.9814 7.27498 10.803 7.93533C10.6278 8.58409 10.4406 9.02449 10.2412 9.25654C10.0449 9.47699 9.81934 9.55281 9.56447 9.48398C9.3096 9.41516 9.15286 9.2361 9.09425 8.94682ZM15.6932 18.4105C16.3068 17.9795 16.7528 17.2485 17.0312 16.2174C17.3159 15.1632 17.297 14.3129 16.9743 13.6664C16.6664 13.0115 16.1186 12.5776 15.3308 12.3649C14.5546 12.1553 13.8539 12.2644 13.2288 12.6922C12.6183 13.1116 12.1708 13.8484 11.8861 14.9026C11.6077 15.9337 11.6282 16.7782 11.9477 17.4363C12.2788 18.0975 12.8324 18.5329 13.6086 18.7425C14.3964 18.9552 15.0913 18.8445 15.6932 18.4105ZM13.5279 16.763C13.4693 16.4737 13.5276 16.0047 13.7027 15.3559C13.8779 14.7071 14.0637 14.2725 14.2599 14.0521C14.4593 13.82 14.6864 13.7384 14.9413 13.8073C15.2078 13.8792 15.3687 14.0656 15.4242 14.3665C15.4828 14.6558 15.4245 15.1248 15.2493 15.7736C15.0742 16.4223 14.8884 16.8569 14.6922 17.0774C14.4959 17.2978 14.2645 17.3721 13.9981 17.3001C13.7548 17.2344 13.5981 17.0554 13.5279 16.763Z"
            fill={props.fill}
        />
    </svg>
);

SellIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default SellIcon;
