import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ShareFilledIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M19.9999 5.73971C19.9999 6.38094 19.8104 7.00786 19.4553 7.54164C19.1002 8.07542 18.5953 8.49223 18.0041 8.73968C17.4129 8.98712 16.7618 9.05416 16.1326 8.93235C15.5034 8.81054 14.9242 8.50533 14.4679 8.05509L9.30994 10.8988C9.56387 11.6079 9.56352 12.3832 9.30894 13.0921L14.4649 15.9338C15.0159 15.3895 15.743 15.06 16.5152 15.0045C17.2874 14.949 18.0541 15.1711 18.6772 15.6309C19.3003 16.0908 19.7388 16.758 19.9139 17.5126C20.089 18.2672 19.9891 19.0596 19.6322 19.7471C19.2754 20.4345 18.6849 20.9719 17.9672 21.2625C17.2496 21.5531 16.4518 21.5778 15.7175 21.3322C14.9833 21.0865 14.3608 20.5866 13.9621 19.9226C13.5634 19.2585 13.4148 18.4738 13.5429 17.7098L8.06494 14.691C7.57577 15.0206 7.0062 15.2108 6.41727 15.2412C5.82833 15.2716 5.24222 15.1411 4.72174 14.8637C4.20126 14.5862 3.76604 14.1723 3.46269 13.6663C3.15935 13.1603 2.99932 12.5812 2.99976 11.9912C3.00019 11.4011 3.16108 10.8223 3.46518 10.3167C3.76927 9.81112 4.20511 9.39787 4.726 9.12121C5.24689 8.84456 5.83319 8.71493 6.42208 8.74622C7.01098 8.77751 7.58026 8.96853 8.06894 9.29883L13.5429 6.27903C13.4702 5.83615 13.4899 5.383 13.6008 4.9481C13.7117 4.51321 13.9113 4.10599 14.1872 3.75208C14.463 3.39816 14.8091 3.10521 15.2036 2.89167C15.5982 2.67812 16.0326 2.54861 16.4796 2.51127C16.9266 2.47394 17.3765 2.52959 17.8009 2.67473C18.2254 2.81987 18.6152 3.05135 18.9459 3.35461C19.2766 3.65786 19.5409 4.02632 19.7223 4.43681C19.9037 4.84729 19.9983 5.29089 19.9999 5.73971Z"
            fill={props.fill}
        />
    </svg>
);

ShareFilledIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default ShareFilledIcon;
