import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ShildIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M12.2237 2.11144C12.0827 2.04148 11.9173 2.04148 11.7763 2.11144C9.46877 3.25653 6.65928 4.50135 3.81841 4.51424C3.51687 4.51561 3.26949 4.76639 3.29149 5.06713L3.875 13.043C3.875 14.9229 4.81802 16.6846 6.40142 17.7627L11.6983 21.7716C11.8767 21.9067 12.1233 21.9067 12.3017 21.7716L17.5986 17.7627C19.182 16.6846 20.125 14.9229 20.125 13.043L20.7085 5.06713C20.7305 4.76639 20.4831 4.51561 20.1816 4.51424C17.3407 4.50135 14.5312 3.25653 12.2237 2.11144ZM16.5444 8.51301C17.0774 8.91799 17.1538 9.64514 16.7151 10.1372L12.0851 15.3294C11.858 15.5841 11.5237 15.7369 11.1666 15.7492C10.8095 15.7615 10.4638 15.6321 10.2168 15.3938L7.34676 12.6246C6.86954 12.1641 6.88706 11.4337 7.3859 10.9932C7.88475 10.5527 8.676 10.5688 9.15323 11.0293L11.0498 12.8593L14.7849 8.67059C15.2236 8.17858 16.0113 8.10803 16.5444 8.51301Z"
            fill={props.fill}
        />
    </svg>
);

ShildIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default ShildIcon;
