import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SoundproofIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 27"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M17.5898 9.6311C17.0851 9.22732 16.328 9.27779 15.899 9.80776C15.47 10.3377 15.5709 11.0948 16.1009 11.5238C16.7823 12.079 17.2113 12.9371 17.2113 13.8708C17.2113 14.8803 16.7318 15.7636 15.9747 16.3188C15.4952 16.6721 15.4195 17.3787 15.798 17.833L15.899 17.9339C16.3028 18.4134 17.0599 18.5143 17.5394 18.1358C18.8012 17.1516 19.6087 15.5869 19.6087 13.8708C19.6087 12.1547 18.8264 10.6406 17.5898 9.6311Z"
            fill={props.fill}
        />
        <path
            d="M20.3407 6.24946C19.836 5.84568 19.1041 5.94663 18.6751 6.42612C18.2713 6.93085 18.3218 7.68794 18.8265 8.09173C20.4921 9.47973 21.5773 11.5491 21.5773 13.8709C21.5773 16.1926 20.4921 18.2873 18.8265 19.65C18.3218 20.0538 18.2713 20.8109 18.6751 21.3156C19.0789 21.8204 19.836 21.9213 20.3407 21.5175C22.5615 19.7257 24 16.975 24 13.8961C23.9748 10.792 22.5615 8.04125 20.3407 6.24946Z"
            fill={props.fill}
        />
        <path
            d="M10.5488 4.40721L4.41638 9.12642H1.41324C0.630912 9.12642 0 9.75734 0 10.5397V17.2021C0 17.9844 0.630912 18.6153 1.41324 18.6153H4.41638L10.5741 23.3346C11.6592 24.1674 13.1987 23.4103 13.1987 22.0223V5.69427C13.1987 4.35673 11.634 3.5744 10.5488 4.40721Z"
            fill={props.fill}
        />
        <path
            d="M20.1696 23.5872C19.7704 23.5343 19.4059 23.3403 19.1546 23.047L1.92003 2.21596C1.6798 1.91513 1.5758 1.54281 1.63044 1.1792C1.68507 0.815587 1.89397 0.489778 2.21214 0.271943C2.53031 0.0541077 2.9323 -0.0383238 3.33152 0.0145563C3.73073 0.0674364 4.09524 0.261397 4.34654 0.554663L21.5811 21.3857C21.8213 21.6866 21.9253 22.0589 21.8707 22.4225C21.816 22.7861 21.6071 23.1119 21.289 23.3298C20.9708 23.5476 20.5688 23.64 20.1696 23.5872Z"
            fill="white"
        />
        <path
            d="M19.0315 25.5298C18.6323 25.477 18.2678 25.283 18.0165 24.9897L1.78197 5.15864C1.54174 4.8578 1.43774 4.48548 1.49237 4.12187C1.54701 3.75826 1.75591 3.43245 2.07408 3.21462C2.39225 2.99678 2.79424 2.90435 3.19345 2.95723C3.59267 3.01011 3.95718 3.20407 4.20848 3.49734L20.443 23.3284C20.6833 23.6293 20.7873 24.0016 20.7326 24.3652C20.678 24.7288 20.4691 25.0546 20.1509 25.2724C19.8327 25.4903 19.4308 25.5827 19.0315 25.5298Z"
            fill={props.fill}
        />
    </svg>
);

SoundproofIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default SoundproofIcon;
