import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const StarIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M11.9764 19.6434L16.9753 22.2628C18.3088 22.9619 19.5929 22.0335 19.34 20.5497L18.3858 15.0013C18.3941 15.0566 18.4133 15.0069 18.3693 15.0456L22.4195 11.1164C23.4974 10.0664 23.0052 8.56049 21.5122 8.34496L15.9304 7.5326C15.9854 7.54089 15.9442 7.5105 15.9662 7.56024L13.4557 2.50923C12.7958 1.16359 11.201 1.16359 10.5411 2.50923L8.03896 7.56024C8.06646 7.5105 8.01972 7.54089 8.07471 7.5326L2.4847 8.34496C0.994403 8.56049 0.504968 10.0664 1.57732 11.1136L5.63028 15.04C5.58904 15.0013 5.60279 15.0511 5.61654 14.9958L4.65966 20.5497C4.4067 22.0252 5.69078 22.9536 7.02435 22.2628L12.0232 19.6379C11.9764 19.6655 12.0287 19.6655 11.9792 19.6379L11.9764 19.6434Z"
            fill={props.fill}
        />
    </svg>
);

StarIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default StarIcon;
