import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const StarNewIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M11.8134 2.07008C11.8899 2.00472 11.9949 1.98089 12.0946 2.01655C12.184 2.04848 12.2541 2.12365 12.2839 2.21945L14.4363 9.14191C14.4728 9.25925 14.5549 9.35391 14.6614 9.40148L19.8158 11.7039C19.9683 11.772 20.0405 11.9598 19.9769 12.1234C19.9465 12.2015 19.8886 12.2636 19.8158 12.2961L14.6614 14.5985C14.5549 14.6461 14.4728 14.7408 14.4363 14.8581L12.2839 21.7806C12.2316 21.9486 12.0622 22.0395 11.9054 21.9834C11.816 21.9515 11.7459 21.8764 11.7161 21.7806L9.56369 14.8581C9.5272 14.7408 9.44512 14.6461 9.33862 14.5985L4.18423 12.2961C4.03167 12.228 3.95953 12.0402 4.0231 11.8766C4.05346 11.7985 4.11137 11.7364 4.18423 11.7039L9.33862 9.40148C9.38297 9.38168 9.42308 9.35371 9.45742 9.31933L10.5038 10.396L11.8134 2.07008Z"
            fill={props.fill}
        />
    </svg>
);

StarNewIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default StarNewIcon;
