import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ToursIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M4.34388 3.71925C6.21098 2.43331 8.40417 1.70258 10.6694 1.61169C12.9347 1.5208 15.1794 2.07347 17.1435 3.20569C19.1077 4.33792 20.7109 6.00337 21.7675 8.00918C22.8241 10.015 23.2909 12.2791 23.1139 14.5393C23.108 14.6546 23.0785 14.7839 23.0722 14.8048C22.5513 15.7519 18.3542 14.2632 13.477 11.5374L10.9179 16.0009H8.5974L11.7554 10.5392C7.00747 7.68232 3.68538 4.78324 4.19388 3.87925C4.23475 3.81804 4.28543 3.76398 4.34388 3.71925ZM13.5039 9.52925C14.9432 10.3723 16.4289 11.1335 17.9539 11.8093C18.8239 8.50925 18.4839 5.29925 16.5739 4.19925C14.6639 3.09925 11.7139 4.40925 9.29388 6.80925C10.6485 7.78913 12.0538 8.69706 13.5039 9.52925ZM22.84 6.88894C22.8382 6.91557 22.8382 6.9423 22.84 6.96894C22.8418 6.9423 22.8418 6.91557 22.84 6.88894ZM5 12.9989L8 16.9989H17C17.5304 16.9989 18.0391 17.2097 18.4142 17.5847C18.7893 17.9598 19 18.4685 19 18.9989V21.9989H17L15 19.9989H6L4 21.9989H2L4 18.6289L0 12.9989H5Z"
            fill={props.fill}
        />
    </svg>
);

ToursIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default ToursIcon;
